/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntComparator;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntIterators;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntSets;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.it.unimi.dsi.fastutil.ints.IntSortedSet;

public final class IntSortedSets {
    public static final EmptySet EMPTY_SET = new EmptySet();

    private IntSortedSets() {
    }

    public static IntSortedSet singleton(int element) {
        return new Singleton(element);
    }

    public static IntSortedSet singleton(int element, IntComparator comparator) {
        return new Singleton(element, comparator);
    }

    public static IntSortedSet singleton(Object element) {
        return new Singleton((int)((Integer)element));
    }

    public static IntSortedSet singleton(Object element, IntComparator comparator) {
        return new Singleton((int)((Integer)element), comparator);
    }

    public static IntSortedSet synchronize(IntSortedSet s2) {
        return new SynchronizedSortedSet(s2);
    }

    public static IntSortedSet synchronize(IntSortedSet s2, Object sync) {
        return new SynchronizedSortedSet(s2, sync);
    }

    public static IntSortedSet unmodifiable(IntSortedSet s2) {
        return new UnmodifiableSortedSet(s2);
    }

    public static class Singleton
    extends IntSets.Singleton
    implements IntSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        final IntComparator comparator;

        protected Singleton(int element, IntComparator comparator) {
            super(element);
            this.comparator = comparator;
        }

        private Singleton(int element) {
            this(element, (IntComparator)null);
        }

        final int compare(int k1, int k2) {
            return this.comparator == null ? Integer.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public IntBidirectionalIterator iterator(int from) {
            IntBidirectionalIterator i = this.iterator();
            if (this.compare(this.element, from) <= 0) {
                i.nextInt();
            }
            return i;
        }

        @Override
        public IntComparator comparator() {
            return this.comparator;
        }

        @Override
        public IntSortedSet subSet(int from, int to) {
            if (this.compare(from, this.element) <= 0 && this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet headSet(int to) {
            if (this.compare(this.element, to) < 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet tailSet(int from) {
            if (this.compare(from, this.element) <= 0) {
                return this;
            }
            return EMPTY_SET;
        }

        @Override
        public int firstInt() {
            return this.element;
        }

        @Override
        public int lastInt() {
            return this.element;
        }

        @Override
        @Deprecated
        public IntSortedSet subSet(Integer from, Integer to) {
            return this.subSet((int)from, (int)to);
        }

        @Override
        @Deprecated
        public IntSortedSet headSet(Integer to) {
            return this.headSet((int)to);
        }

        @Override
        @Deprecated
        public IntSortedSet tailSet(Integer from) {
            return this.tailSet((int)from);
        }

        @Override
        @Deprecated
        public Integer first() {
            return this.element;
        }

        @Override
        @Deprecated
        public Integer last() {
            return this.element;
        }
    }

    public static class SynchronizedSortedSet
    extends IntSets.SynchronizedSet
    implements IntSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected SynchronizedSortedSet(IntSortedSet s2, Object sync) {
            super(s2, sync);
            this.sortedSet = s2;
        }

        protected SynchronizedSortedSet(IntSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IntComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.comparator();
            }
        }

        @Override
        public IntSortedSet subSet(int from, int to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        @Override
        public IntSortedSet headSet(int to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        @Override
        public IntSortedSet tailSet(int from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }

        @Override
        public IntBidirectionalIterator iterator() {
            return this.sortedSet.iterator();
        }

        @Override
        public IntBidirectionalIterator iterator(int from) {
            return this.sortedSet.iterator(from);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int firstInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.firstInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastInt() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.lastInt();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Integer first() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Integer last() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedSet.last();
            }
        }

        @Override
        @Deprecated
        public IntSortedSet subSet(Integer from, Integer to) {
            return new SynchronizedSortedSet(this.sortedSet.subSet(from, to), this.sync);
        }

        @Override
        @Deprecated
        public IntSortedSet headSet(Integer to) {
            return new SynchronizedSortedSet(this.sortedSet.headSet(to), this.sync);
        }

        @Override
        @Deprecated
        public IntSortedSet tailSet(Integer from) {
            return new SynchronizedSortedSet(this.sortedSet.tailSet(from), this.sync);
        }
    }

    public static class UnmodifiableSortedSet
    extends IntSets.UnmodifiableSet
    implements IntSortedSet,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final IntSortedSet sortedSet;

        protected UnmodifiableSortedSet(IntSortedSet s2) {
            super(s2);
            this.sortedSet = s2;
        }

        @Override
        public IntComparator comparator() {
            return this.sortedSet.comparator();
        }

        @Override
        public IntSortedSet subSet(int from, int to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        @Override
        public IntSortedSet headSet(int to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        @Override
        public IntSortedSet tailSet(int from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }

        @Override
        public IntBidirectionalIterator iterator() {
            return IntIterators.unmodifiable(this.sortedSet.iterator());
        }

        @Override
        public IntBidirectionalIterator iterator(int from) {
            return IntIterators.unmodifiable(this.sortedSet.iterator(from));
        }

        @Override
        public int firstInt() {
            return this.sortedSet.firstInt();
        }

        @Override
        public int lastInt() {
            return this.sortedSet.lastInt();
        }

        @Override
        @Deprecated
        public Integer first() {
            return this.sortedSet.first();
        }

        @Override
        @Deprecated
        public Integer last() {
            return this.sortedSet.last();
        }

        @Override
        @Deprecated
        public IntSortedSet subSet(Integer from, Integer to) {
            return new UnmodifiableSortedSet(this.sortedSet.subSet(from, to));
        }

        @Override
        @Deprecated
        public IntSortedSet headSet(Integer to) {
            return new UnmodifiableSortedSet(this.sortedSet.headSet(to));
        }

        @Override
        @Deprecated
        public IntSortedSet tailSet(Integer from) {
            return new UnmodifiableSortedSet(this.sortedSet.tailSet(from));
        }
    }

    public static class EmptySet
    extends IntSets.EmptySet
    implements IntSortedSet,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySet() {
        }

        @Override
        public IntBidirectionalIterator iterator(int from) {
            return IntIterators.EMPTY_ITERATOR;
        }

        @Override
        public IntSortedSet subSet(int from, int to) {
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet headSet(int from) {
            return EMPTY_SET;
        }

        @Override
        public IntSortedSet tailSet(int to) {
            return EMPTY_SET;
        }

        @Override
        public int firstInt() {
            throw new NoSuchElementException();
        }

        @Override
        public int lastInt() {
            throw new NoSuchElementException();
        }

        @Override
        public IntComparator comparator() {
            return null;
        }

        @Override
        @Deprecated
        public IntSortedSet subSet(Integer from, Integer to) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public IntSortedSet headSet(Integer from) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public IntSortedSet tailSet(Integer to) {
            return EMPTY_SET;
        }

        @Override
        @Deprecated
        public Integer first() {
            throw new NoSuchElementException();
        }

        @Override
        @Deprecated
        public Integer last() {
            throw new NoSuchElementException();
        }

        @Override
        public Object clone() {
            return EMPTY_SET;
        }

        private Object readResolve() {
            return EMPTY_SET;
        }
    }
}

