/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.column.ColumnDescriptor;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate.Operators;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.filter2.predicate.ValidTypeMap;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.seatunnel.shade.connector.file.org.apache.parquet.schema.MessageType;

public class SchemaCompatibilityValidator
implements FilterPredicate.Visitor<Void> {
    private final Map<ColumnPath, Class<?>> columnTypesEncountered = new HashMap();
    private final Map<ColumnPath, ColumnDescriptor> columnsAccordingToSchema = new HashMap<ColumnPath, ColumnDescriptor>();

    public static void validate(FilterPredicate predicate, MessageType schema) {
        Objects.requireNonNull(predicate, "predicate cannot be null");
        Objects.requireNonNull(schema, "schema cannot be null");
        predicate.accept(new SchemaCompatibilityValidator(schema));
    }

    private SchemaCompatibilityValidator(MessageType schema) {
        for (ColumnDescriptor cd2 : schema.getColumns()) {
            ColumnPath columnPath = ColumnPath.get(cd2.getPath());
            this.columnsAccordingToSchema.put(columnPath, cd2);
        }
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.Eq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.NotEq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.Lt<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.LtEq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.Gt<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.GtEq<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.In<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public <T extends Comparable<T>> Void visit(Operators.NotIn<T> pred) {
        this.validateColumnFilterPredicate(pred);
        return null;
    }

    @Override
    public Void visit(Operators.And and) {
        and.getLeft().accept(this);
        and.getRight().accept(this);
        return null;
    }

    @Override
    public Void visit(Operators.Or or) {
        or.getLeft().accept(this);
        or.getRight().accept(this);
        return null;
    }

    @Override
    public Void visit(Operators.Not not) {
        not.getPredicate().accept(this);
        return null;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Void visit(Operators.UserDefined<T, U> udp) {
        this.validateColumn(udp.getColumn());
        return null;
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> Void visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return udp.getUserDefined().accept(this);
    }

    private <T extends Comparable<T>> void validateColumnFilterPredicate(Operators.ColumnFilterPredicate<T> pred) {
        this.validateColumn(pred.getColumn());
    }

    private <T extends Comparable<T>> void validateColumnFilterPredicate(Operators.SetColumnFilterPredicate<T> pred) {
        this.validateColumn(pred.getColumn());
    }

    private <T extends Comparable<T>> void validateColumn(Operators.Column<T> column) {
        ColumnDescriptor descriptor;
        ColumnPath path = column.getColumnPath();
        Class<?> alreadySeen = this.columnTypesEncountered.get(path);
        if (alreadySeen != null && !alreadySeen.equals(column.getColumnType())) {
            throw new IllegalArgumentException("Column: " + path.toDotString() + " was provided with different types in the same predicate. Found both: (" + alreadySeen + ", " + column.getColumnType() + ")");
        }
        if (alreadySeen == null) {
            this.columnTypesEncountered.put(path, column.getColumnType());
        }
        if ((descriptor = this.getColumnDescriptor(path)) == null) {
            return;
        }
        if (descriptor.getMaxRepetitionLevel() > 0) {
            throw new IllegalArgumentException("FilterPredicates do not currently support repeated columns. Column " + path.toDotString() + " is repeated.");
        }
        ValidTypeMap.assertTypeValid(column, descriptor.getType());
    }

    private ColumnDescriptor getColumnDescriptor(ColumnPath columnPath) {
        return this.columnsAccordingToSchema.get(columnPath);
    }
}

