/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;

public class JsonReadStrategy
extends AbstractReadStrategy {
    private DeserializationSchema<SeaTunnelRow> deserializationSchema;

    @Override
    public void setSeaTunnelRowTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        super.setSeaTunnelRowTypeInfo(seaTunnelRowType);
        this.deserializationSchema = this.isMergePartition ? new JsonDeserializationSchema(false, false, this.seaTunnelRowTypeWithPartition) : new JsonDeserializationSchema(false, false, this.seaTunnelRowType);
    }

    @Override
    public void read(String path, Collector<SeaTunnelRow> output) throws FileConnectorException, IOException {
        Configuration conf = this.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path filePath = new Path(path);
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(filePath), StandardCharsets.UTF_8));){
            reader.lines().forEach(line -> {
                try {
                    SeaTunnelRow seaTunnelRow = (SeaTunnelRow)this.deserializationSchema.deserialize(line.getBytes());
                    if (this.isMergePartition) {
                        int index = this.seaTunnelRowType.getTotalFields();
                        for (String value : partitionsMap.values()) {
                            seaTunnelRow.setField(index++, (Object)value);
                        }
                    }
                    output.collect((Object)seaTunnelRow);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Read data from this file [%s] failed", filePath);
                    throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, errorMsg);
                }
            });
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(HadoopConf hadoopConf, String path) throws FileConnectorException {
        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.UNSUPPORTED_OPERATION, "User must defined schema for json file type");
    }
}

