/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.sink.util.FileSystemUtils;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReadStrategy
implements ReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractReadStrategy.class);
    protected static final String[] TYPE_ARRAY_STRING = new String[0];
    protected static final Boolean[] TYPE_ARRAY_BOOLEAN = new Boolean[0];
    protected static final Byte[] TYPE_ARRAY_BYTE = new Byte[0];
    protected static final Short[] TYPE_ARRAY_SHORT = new Short[0];
    protected static final Integer[] TYPE_ARRAY_INTEGER = new Integer[0];
    protected static final Long[] TYPE_ARRAY_LONG = new Long[0];
    protected static final Float[] TYPE_ARRAY_FLOAT = new Float[0];
    protected static final Double[] TYPE_ARRAY_DOUBLE = new Double[0];
    protected static final BigDecimal[] TYPE_ARRAY_BIG_DECIMAL = new BigDecimal[0];
    protected static final LocalDate[] TYPE_ARRAY_LOCAL_DATE = new LocalDate[0];
    protected static final LocalDateTime[] TYPE_ARRAY_LOCAL_DATETIME = new LocalDateTime[0];
    protected HadoopConf hadoopConf;
    protected SeaTunnelRowType seaTunnelRowType;
    protected SeaTunnelRowType seaTunnelRowTypeWithPartition;
    protected Config pluginConfig;
    protected List<String> fileNames = new ArrayList<String>();
    protected List<String> readPartitions = new ArrayList<String>();
    protected List<String> readColumns = new ArrayList<String>();
    protected boolean isMergePartition = true;
    protected long skipHeaderNumber = (Long)BaseSourceConfig.SKIP_HEADER_ROW_NUMBER.defaultValue();
    protected boolean isKerberosAuthorization = false;

    @Override
    public void init(HadoopConf conf) {
        this.hadoopConf = conf;
    }

    @Override
    public void setSeaTunnelRowTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        this.seaTunnelRowType = seaTunnelRowType;
        this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes(this.fileNames.get(0), seaTunnelRowType);
    }

    @Override
    public Configuration getConfiguration(HadoopConf hadoopConf) {
        Configuration configuration = new Configuration();
        configuration.setBoolean("parquet.avro.readInt96AsFixed", true);
        configuration.setBoolean("parquet.avro.writeFixedAsInt96", true);
        configuration.setBoolean("parquet.avro.add-list-element-records", false);
        configuration.setBoolean("parquet.avro.write-old-list-structure", true);
        configuration.set("fs.defaultFS", hadoopConf.getHdfsNameKey());
        configuration.set(String.format("fs.%s.impl", hadoopConf.getSchema()), hadoopConf.getFsHdfsImpl());
        hadoopConf.setExtraOptionsForConfiguration(configuration);
        String principal = hadoopConf.getKerberosPrincipal();
        String keytabPath = hadoopConf.getKerberosKeytabPath();
        if (!this.isKerberosAuthorization) {
            FileSystemUtils.doKerberosAuthentication(configuration, principal, keytabPath);
            this.isKerberosAuthorization = true;
        }
        return configuration;
    }

    Configuration getConfiguration() {
        return this.getConfiguration(this.hadoopConf);
    }

    boolean checkFileType(String path) {
        return true;
    }

    @Override
    public List<String> getFileNamesByPath(HadoopConf hadoopConf, String path) throws IOException {
        FileStatus[] stats;
        Configuration configuration = this.getConfiguration(hadoopConf);
        FileSystem hdfs = FileSystem.get((Configuration)configuration);
        ArrayList<String> fileNames = new ArrayList<String>();
        Path listFiles = new Path(path);
        block0: for (FileStatus fileStatus : stats = hdfs.listStatus(listFiles)) {
            if (fileStatus.isDirectory()) {
                fileNames.addAll(this.getFileNamesByPath(hadoopConf, fileStatus.getPath().toString()));
                continue;
            }
            if (!fileStatus.isFile() || fileStatus.getPath().getName().equals("_SUCCESS")) continue;
            String filePath = fileStatus.getPath().toString();
            if (!this.readPartitions.isEmpty()) {
                for (String readPartition : this.readPartitions) {
                    if (!filePath.contains(readPartition)) continue;
                    fileNames.add(filePath);
                    this.fileNames.add(filePath);
                    continue block0;
                }
                continue;
            }
            fileNames.add(filePath);
            this.fileNames.add(filePath);
        }
        return fileNames;
    }

    @Override
    public void setPluginConfig(Config pluginConfig) {
        this.pluginConfig = pluginConfig;
        if (pluginConfig.hasPath(BaseSourceConfig.PARSE_PARTITION_FROM_PATH.key())) {
            this.isMergePartition = pluginConfig.getBoolean(BaseSourceConfig.PARSE_PARTITION_FROM_PATH.key());
        }
        if (pluginConfig.hasPath(BaseSourceConfig.SKIP_HEADER_ROW_NUMBER.key())) {
            this.skipHeaderNumber = pluginConfig.getLong(BaseSourceConfig.SKIP_HEADER_ROW_NUMBER.key());
        }
        if (pluginConfig.hasPath(BaseSourceConfig.READ_PARTITIONS.key())) {
            this.readPartitions.addAll(pluginConfig.getStringList(BaseSourceConfig.READ_PARTITIONS.key()));
        }
        if (pluginConfig.hasPath(BaseSourceConfig.READ_COLUMNS.key())) {
            this.readColumns.addAll(pluginConfig.getStringList(BaseSourceConfig.READ_COLUMNS.key()));
        }
    }

    @Override
    public SeaTunnelRowType getActualSeaTunnelRowTypeInfo() {
        return this.isMergePartition ? this.seaTunnelRowTypeWithPartition : this.seaTunnelRowType;
    }

    protected Map<String, String> parsePartitionsByPath(String path) {
        LinkedHashMap<String, String> partitions = new LinkedHashMap<String, String>();
        Arrays.stream(path.split("/", -1)).filter(split -> split.contains("=")).map(split -> split.split("=", -1)).forEach(kv -> partitions.put(kv[0], kv[1]));
        return partitions;
    }

    protected SeaTunnelRowType mergePartitionTypes(String path, SeaTunnelRowType seaTunnelRowType) {
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        if (partitionsMap.isEmpty()) {
            return seaTunnelRowType;
        }
        String[] partitionNames = partitionsMap.keySet().toArray(TYPE_ARRAY_STRING);
        Object[] partitionTypes = new SeaTunnelDataType[partitionNames.length];
        Arrays.fill(partitionTypes, BasicType.STRING_TYPE);
        String[] fieldNames = seaTunnelRowType.getFieldNames();
        SeaTunnelDataType[] fieldTypes = seaTunnelRowType.getFieldTypes();
        String[] newFieldNames = new String[fieldNames.length + partitionNames.length];
        SeaTunnelDataType[] newFieldTypes = new SeaTunnelDataType[fieldTypes.length + partitionTypes.length];
        System.arraycopy(fieldNames, 0, newFieldNames, 0, fieldNames.length);
        System.arraycopy(partitionNames, 0, newFieldNames, fieldNames.length, partitionNames.length);
        System.arraycopy(fieldTypes, 0, newFieldTypes, 0, fieldTypes.length);
        System.arraycopy(partitionTypes, 0, newFieldTypes, fieldTypes.length, partitionTypes.length);
        return new SeaTunnelRowType(newFieldNames, newFieldTypes);
    }
}

