/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.writer;

import io.airlift.compress.lzo.LzopCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.seatunnel.api.serialization.SerializationSchema;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.AbstractWriteStrategy;
import org.apache.seatunnel.format.text.TextSerializationSchema;

public class TextWriteStrategy
extends AbstractWriteStrategy {
    private final Map<String, FSDataOutputStream> beingWrittenOutputStream = new HashMap<String, FSDataOutputStream>();
    private final Map<String, Boolean> isFirstWrite = new HashMap<String, Boolean>();
    private final String fieldDelimiter;
    private final String rowDelimiter;
    private final DateUtils.Formatter dateFormat;
    private final DateTimeUtils.Formatter dateTimeFormat;
    private final TimeUtils.Formatter timeFormat;
    private SerializationSchema serializationSchema;

    public TextWriteStrategy(FileSinkConfig fileSinkConfig) {
        super(fileSinkConfig);
        this.fieldDelimiter = fileSinkConfig.getFieldDelimiter();
        this.rowDelimiter = fileSinkConfig.getRowDelimiter();
        this.dateFormat = fileSinkConfig.getDateFormat();
        this.dateTimeFormat = fileSinkConfig.getDatetimeFormat();
        this.timeFormat = fileSinkConfig.getTimeFormat();
    }

    @Override
    public void setSeaTunnelRowTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        super.setSeaTunnelRowTypeInfo(seaTunnelRowType);
        this.serializationSchema = TextSerializationSchema.builder().seaTunnelRowType(this.buildSchemaWithRowType(seaTunnelRowType, this.sinkColumnsIndexInRow)).delimiter(this.fieldDelimiter).dateFormatter(this.dateFormat).dateTimeFormatter(this.dateTimeFormat).timeFormatter(this.timeFormat).build();
    }

    @Override
    public void write(@NonNull SeaTunnelRow seaTunnelRow) {
        if (seaTunnelRow == null) {
            throw new NullPointerException("seaTunnelRow is marked non-null but is null");
        }
        super.write(seaTunnelRow);
        String filePath = this.getOrCreateFilePathBeingWritten(seaTunnelRow);
        FSDataOutputStream fsDataOutputStream = this.getOrCreateOutputStream(filePath);
        try {
            if (this.isFirstWrite.get(filePath).booleanValue()) {
                this.isFirstWrite.put(filePath, false);
            } else {
                fsDataOutputStream.write(this.rowDelimiter.getBytes());
            }
            fsDataOutputStream.write(this.serializationSchema.serialize(seaTunnelRow.copy(this.sinkColumnsIndexInRow.stream().mapToInt(Integer::intValue).toArray())));
        }
        catch (IOException e) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, String.format("Write data to file [%s] failed", filePath), e);
        }
    }

    @Override
    public void finishAndCloseFile() {
        this.beingWrittenOutputStream.forEach((key, value) -> {
            try {
                value.flush();
            }
            catch (IOException e) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FLUSH_DATA_FAILED, String.format("Flush data to this file [%s] failed", key), e);
            }
            finally {
                try {
                    value.close();
                }
                catch (IOException e) {
                    this.log.error("error when close output stream {}", key, (Object)e);
                }
            }
            this.needMoveFiles.put(key, this.getTargetLocation((String)key));
        });
        this.beingWrittenOutputStream.clear();
        this.isFirstWrite.clear();
    }

    private FSDataOutputStream getOrCreateOutputStream(@NonNull String filePath) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FSDataOutputStream fsDataOutputStream = this.beingWrittenOutputStream.get(filePath);
        if (fsDataOutputStream == null) {
            try {
                switch (this.compressFormat) {
                    case LZO: {
                        LzopCodec lzo = new LzopCodec();
                        CompressionOutputStream out = lzo.createOutputStream((OutputStream)this.fileSystemUtils.getOutputStream(filePath));
                        fsDataOutputStream = new FSDataOutputStream((OutputStream)out, null);
                        break;
                    }
                    case NONE: {
                        fsDataOutputStream = this.fileSystemUtils.getOutputStream(filePath);
                        break;
                    }
                    default: {
                        this.log.warn("Text file does not support this compress type: {}", (Object)this.compressFormat.getCompressCodec());
                        fsDataOutputStream = this.fileSystemUtils.getOutputStream(filePath);
                    }
                }
                this.beingWrittenOutputStream.put(filePath, fsDataOutputStream);
                this.isFirstWrite.put(filePath, true);
            }
            catch (IOException e) {
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, String.format("Open file output stream [%s] failed", filePath), e);
            }
        }
        return fsDataOutputStream;
    }
}

