/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.sink.util;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.seatunnel.common.exception.CommonErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemUtils
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FileSystemUtils.class);
    private static final int WRITE_BUFFER_SIZE = 2048;
    private final HadoopConf hadoopConf;
    private transient Configuration configuration;

    public FileSystemUtils(HadoopConf hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    public static void doKerberosAuthentication(Configuration configuration, String principal, String keytabPath) {
        if (StringUtils.isBlank(principal) || StringUtils.isBlank(keytabPath)) {
            log.warn("Principal [{}] or keytabPath [{}] is empty, it will skip kerberos authentication", (Object)principal, (Object)keytabPath);
        } else {
            configuration.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)configuration);
            try {
                log.info("Start Kerberos authentication using principal {} and keytab {}", (Object)principal, (Object)keytabPath);
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytabPath);
                log.info("Kerberos authentication successful");
            }
            catch (IOException e) {
                String errorMsg = String.format("Kerberos authentication failed using this principal [%s] and keytab path [%s]", principal, keytabPath);
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.KERBEROS_AUTHORIZED_FAILED, errorMsg, e);
            }
        }
    }

    public Configuration getConfiguration(HadoopConf hadoopConf) {
        Configuration configuration = new Configuration();
        configuration.set("fs.defaultFS", hadoopConf.getHdfsNameKey());
        configuration.set(String.format("fs.%s.impl", hadoopConf.getSchema()), hadoopConf.getFsHdfsImpl());
        hadoopConf.setExtraOptionsForConfiguration(configuration);
        String principal = hadoopConf.getKerberosPrincipal();
        String keytabPath = hadoopConf.getKerberosKeytabPath();
        FileSystemUtils.doKerberosAuthentication(configuration, principal, keytabPath);
        return configuration;
    }

    public FileSystem getFileSystem(@NonNull String path) throws IOException {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (this.configuration == null) {
            this.configuration = this.getConfiguration(this.hadoopConf);
        }
        FileSystem fileSystem = FileSystem.get((URI)URI.create(path.replaceAll("\\\\", "/")), (Configuration)this.configuration);
        fileSystem.setWriteChecksum(false);
        return fileSystem;
    }

    public FSDataOutputStream getOutputStream(@NonNull String outFilePath) throws IOException {
        if (outFilePath == null) {
            throw new NullPointerException("outFilePath is marked non-null but is null");
        }
        FileSystem fileSystem = this.getFileSystem(outFilePath);
        Path path = new Path(outFilePath);
        return fileSystem.create(path, true, 2048);
    }

    public void createFile(@NonNull String filePath) throws IOException {
        Path path;
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FileSystem fileSystem = this.getFileSystem(filePath);
        if (!fileSystem.createNewFile(path = new Path(filePath))) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, "create file " + filePath + " error");
        }
    }

    public void deleteFile(@NonNull String file) throws IOException {
        Path path;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        FileSystem fileSystem = this.getFileSystem(file);
        if (fileSystem.exists(path = new Path(file)) && !fileSystem.delete(path, true)) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, "delete file " + file + " error");
        }
    }

    public void renameFile(@NonNull String oldName, @NonNull String newName, boolean rmWhenExist) throws IOException {
        if (oldName == null) {
            throw new NullPointerException("oldName is marked non-null but is null");
        }
        if (newName == null) {
            throw new NullPointerException("newName is marked non-null but is null");
        }
        FileSystem fileSystem = this.getFileSystem(newName);
        log.info("begin rename file oldName :[" + oldName + "] to newName :[" + newName + "]");
        Path oldPath = new Path(oldName);
        Path newPath = new Path(newName);
        if (!this.fileExist(oldPath.toString())) {
            log.warn("rename file :[" + oldPath + "] to [" + newPath + "] already finished in the last commit, skip");
            return;
        }
        if (rmWhenExist && this.fileExist(newName) && this.fileExist(oldName)) {
            fileSystem.delete(newPath, true);
            log.info("Delete already file: {}", (Object)newPath);
        }
        if (!this.fileExist(newPath.getParent().toString())) {
            this.createDir(newPath.getParent().toString());
        }
        if (!fileSystem.rename(oldPath, newPath)) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, "rename file :[" + oldPath + "] to [" + newPath + "] error");
        }
        log.info("rename file :[" + oldPath + "] to [" + newPath + "] finish");
    }

    public void createDir(@NonNull String filePath) throws IOException {
        Path dfs;
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FileSystem fileSystem = this.getFileSystem(filePath);
        if (!fileSystem.mkdirs(dfs = new Path(filePath))) {
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCode.FILE_OPERATION_FAILED, "create dir " + filePath + " error");
        }
    }

    public boolean fileExist(@NonNull String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FileSystem fileSystem = this.getFileSystem(filePath);
        Path fileName = new Path(filePath);
        return fileSystem.exists(fileName);
    }

    public List<Path> dirList(@NonNull String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        FileSystem fileSystem = this.getFileSystem(filePath);
        ArrayList<Path> pathList = new ArrayList<Path>();
        if (!this.fileExist(filePath)) {
            return pathList;
        }
        Path fileName = new Path(filePath);
        FileStatus[] status = fileSystem.listStatus(fileName);
        if (status != null) {
            for (FileStatus fileStatus : status) {
                if (!fileStatus.isDirectory()) continue;
                pathList.add(fileStatus.getPath());
            }
        }
        return pathList;
    }
}

