/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.source;

import com.google.auto.service.AutoService;
import java.util.Arrays;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3Config;
import org.apache.seatunnel.connectors.seatunnel.file.s3.source.S3FileSource;

@AutoService(value={Factory.class})
public class S3FileSourceFactory
implements TableSourceFactory {
    public String factoryIdentifier() {
        return FileSystemType.S3.getFileSystemPluginName();
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{S3Config.FILE_PATH}).required(new Option[]{S3Config.FILE_FORMAT_TYPE}).required(new Option[]{S3Config.S3_BUCKET}).required(new Option[]{S3Config.FS_S3A_ENDPOINT}).required(new Option[]{S3Config.S3A_AWS_CREDENTIALS_PROVIDER}).conditional(S3Config.S3A_AWS_CREDENTIALS_PROVIDER, (Object)S3Config.S3aAwsCredentialsProvider.SimpleAWSCredentialsProvider, new Option[]{S3Config.S3_ACCESS_KEY, S3Config.S3_SECRET_KEY}).optional(new Option[]{S3Config.S3_PROPERTIES}).conditional(BaseSourceConfig.FILE_FORMAT_TYPE, (Object)FileFormat.TEXT, new Option[]{BaseSourceConfig.DELIMITER}).conditional(BaseSourceConfig.FILE_FORMAT_TYPE, Arrays.asList(FileFormat.TEXT, FileFormat.JSON), new Option[]{CatalogTableUtil.SCHEMA}).optional(new Option[]{BaseSourceConfig.PARSE_PARTITION_FROM_PATH}).optional(new Option[]{BaseSourceConfig.DATE_FORMAT}).optional(new Option[]{BaseSourceConfig.DATETIME_FORMAT}).optional(new Option[]{BaseSourceConfig.TIME_FORMAT}).build();
    }

    public Class<? extends SeaTunnelSource> getSourceClass() {
        return S3FileSource.class;
    }
}

