/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3Config;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class S3Conf
extends HadoopConf {
    private static final String HDFS_S3N_IMPL = "org.apache.hadoop.fs.s3native.NativeS3FileSystem";
    private static final String HDFS_S3A_IMPL = "org.apache.hadoop.fs.s3a.S3AFileSystem";
    private static final String S3A_SCHEMA = "s3a";
    private static final String DEFAULT_SCHEMA = "s3n";
    private static String SCHEMA = "s3n";

    @Override
    public String getFsHdfsImpl() {
        return this.switchHdfsImpl();
    }

    @Override
    public String getSchema() {
        return SCHEMA;
    }

    private S3Conf(String hdfsNameKey) {
        super(hdfsNameKey);
    }

    public static HadoopConf buildWithConfig(Config config) {
        S3Conf hadoopConf = new S3Conf(config.getString(S3Config.S3_BUCKET.key()));
        String bucketName = config.getString(S3Config.S3_BUCKET.key());
        if (bucketName.startsWith(S3A_SCHEMA)) {
            SCHEMA = S3A_SCHEMA;
        }
        HashMap<String, String> s3Options = new HashMap<String, String>();
        S3Conf.putS3SK(s3Options, config);
        if (CheckConfigUtil.isValidParam((Config)config, (String)S3Config.S3_PROPERTIES.key())) {
            config.getObject(S3Config.S3_PROPERTIES.key()).forEach((key, value) -> s3Options.put((String)key, String.valueOf(value.unwrapped())));
        }
        s3Options.put(S3Config.S3A_AWS_CREDENTIALS_PROVIDER.key(), config.getString(S3Config.S3A_AWS_CREDENTIALS_PROVIDER.key()));
        s3Options.put(S3Config.FS_S3A_ENDPOINT.key(), config.getString(S3Config.FS_S3A_ENDPOINT.key()));
        hadoopConf.setExtraOptions(s3Options);
        return hadoopConf;
    }

    private String switchHdfsImpl() {
        switch (SCHEMA) {
            case "s3a": {
                return HDFS_S3A_IMPL;
            }
        }
        return HDFS_S3N_IMPL;
    }

    private static void putS3SK(Map<String, String> s3Options, Config config) {
        if (!CheckConfigUtil.isValidParam((Config)config, (String)S3Config.S3_ACCESS_KEY.key()) && !CheckConfigUtil.isValidParam((Config)config, (String)S3Config.S3_SECRET_KEY.key())) {
            return;
        }
        String accessKey = config.getString(S3Config.S3_ACCESS_KEY.key());
        String secretKey = config.getString(S3Config.S3_SECRET_KEY.key());
        if (S3A_SCHEMA.equals(SCHEMA)) {
            s3Options.put("fs.s3a.access.key", accessKey);
            s3Options.put("fs.s3a.secret.key", secretKey);
            return;
        }
        s3Options.put("fs.s3n.awsAccessKeyId", accessKey);
        s3Options.put("fs.s3n.awsSecretAccessKey", secretKey);
    }
}

