/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.catalog;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertException;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;

@AutoService(value={DataTypeConvertor.class})
public class S3DataTypeConvertor
implements DataTypeConvertor<SeaTunnelRowType> {
    public SeaTunnelDataType<?> toSeaTunnelType(String connectorDataType) {
        Preconditions.checkNotNull(connectorDataType, "connectorDataType can not be null");
        return CatalogTableUtil.parseDataType((String)connectorDataType);
    }

    public SeaTunnelDataType<?> toSeaTunnelType(SeaTunnelRowType connectorDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        return connectorDataType;
    }

    public SeaTunnelRowType toConnectorType(SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> dataTypeProperties) throws DataTypeConvertException {
        if (!(seaTunnelDataType instanceof SeaTunnelRowType)) {
            throw DataTypeConvertException.convertToConnectorDataTypeException(seaTunnelDataType);
        }
        return (SeaTunnelRowType)seaTunnelDataType;
    }

    public String getIdentity() {
        return "S3";
    }
}

