/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.s3.catalog;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.exception.CatalogException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.DatabaseNotExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableAlreadyExistException;
import org.apache.seatunnel.api.table.catalog.exception.TableNotExistException;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3Conf;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3Config;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Catalog
implements Catalog {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3Catalog.class);
    private final String catalogName;
    private final Config s3Config;
    private String defaultDatabase;
    private FileSystem fileSystem;

    public S3Catalog(String catalogName, Config s3Config) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName, (Object)"catalogName cannot be null");
        this.s3Config = (Config)Preconditions.checkNotNull((Object)s3Config, (Object)"s3Config cannot be null");
    }

    public void open() throws CatalogException {
        ReadStrategy readStrategy = ReadStrategyFactory.of(this.s3Config.getString(S3Config.FILE_FORMAT_TYPE.key()));
        readStrategy.setPluginConfig(this.s3Config);
        this.defaultDatabase = this.s3Config.getString(S3Config.FILE_PATH.key());
        readStrategy = ReadStrategyFactory.of(this.s3Config.getString(S3Config.FILE_FORMAT_TYPE.key()));
        readStrategy.setPluginConfig(this.s3Config);
        try {
            this.fileSystem = FileSystem.get((Configuration)readStrategy.getConfiguration(S3Conf.buildWithConfig(this.s3Config)));
        }
        catch (IOException e) {
            throw new CatalogException("Open S3Catalog failed", (Throwable)e);
        }
        LOGGER.info("S3Catalog {} is opened", (Object)this.catalogName);
    }

    public void close() throws CatalogException {
        LOGGER.info("S3Catalog {} is closed", (Object)this.catalogName);
    }

    public String getDefaultDatabase() throws CatalogException {
        return this.defaultDatabase;
    }

    public boolean databaseExists(String databaseName) throws CatalogException {
        try {
            return this.fileSystem.getFileStatus(new Path(databaseName)).isDirectory();
        }
        catch (FileNotFoundException e) {
            LOGGER.debug("Database {} does not exist", (Object)databaseName, (Object)e);
            return false;
        }
        catch (Exception ex) {
            throw new CatalogException("Check database exists failed", (Throwable)ex);
        }
    }

    public List<String> listDatabases() throws CatalogException {
        if (this.databaseExists(this.defaultDatabase)) {
            return Lists.newArrayList(this.defaultDatabase);
        }
        return Collections.emptyList();
    }

    public List<String> listTables(String databaseName) throws CatalogException, DatabaseNotExistException {
        if (this.databaseExists(databaseName)) {
            return Lists.newArrayList(databaseName);
        }
        return Collections.emptyList();
    }

    public boolean tableExists(TablePath tablePath) throws CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath cannot be null");
        return this.databaseExists(tablePath.getTableName());
    }

    public CatalogTable getTable(TablePath tablePath) throws CatalogException, TableNotExistException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath cannot be null");
        TableIdentifier tableIdentifier = TableIdentifier.of((String)this.catalogName, (String)tablePath.getDatabaseName(), (String)tablePath.getTableName());
        TableSchema tableSchema = TableSchema.builder().build();
        return CatalogTable.of((TableIdentifier)tableIdentifier, (TableSchema)tableSchema, Collections.emptyMap(), Collections.emptyList(), (String)"");
    }

    public void createTable(TablePath tablePath, CatalogTable table, boolean ignoreIfExists) throws TableAlreadyExistException, DatabaseNotExistException, CatalogException {
        this.createDatabase(tablePath, ignoreIfExists);
    }

    public void dropTable(TablePath tablePath, boolean ignoreIfNotExists) throws TableNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath cannot be null");
        try {
            this.fileSystem.delete(new Path(tablePath.getTableName()), true);
        }
        catch (IOException e) {
            throw new CatalogException("Drop table failed", (Throwable)e);
        }
    }

    public void createDatabase(TablePath tablePath, boolean ignoreIfExists) throws DatabaseAlreadyExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath cannot be null");
        try {
            this.fileSystem.create(new Path(tablePath.getTableName()));
        }
        catch (FileAlreadyExistsException e) {
            if (!ignoreIfExists) {
                throw new TableAlreadyExistException(this.catalogName, tablePath, (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Create table %s at catalog %s failed", tablePath.getTableName(), this.catalogName), (Throwable)e);
        }
    }

    public void dropDatabase(TablePath tablePath, boolean ignoreIfNotExists) throws DatabaseNotExistException, CatalogException {
        Preconditions.checkNotNull((Object)tablePath, (Object)"tablePath cannot be null");
        try {
            this.fileSystem.delete(new Path(tablePath.getDatabaseName()), true);
        }
        catch (IOException e) {
            throw new CatalogException(String.format("Drop database: %s failed", tablePath.getDatabaseName()), (Throwable)e);
        }
    }
}

