/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.metrics;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import org.apache.ratis.metrics.MetricRegistries;
import org.apache.ratis.metrics.MetricRegistryInfo;
import org.apache.ratis.metrics.RatisMetricRegistry;
import org.apache.ratis.util.TimeDuration;

public interface JVMMetrics {
    public static void initJvmMetrics(TimeDuration consoleReportRate) {
        MetricRegistries registries = MetricRegistries.global();
        JVMMetrics.addJvmMetrics(registries);
        registries.enableConsoleReporter(consoleReportRate);
        registries.enableJmxReporter();
    }

    public static void addJvmMetrics(MetricRegistries registries) {
        MetricRegistryInfo info = new MetricRegistryInfo("jvm", "ratis_jvm", "jvm", "jvm metrics");
        RatisMetricRegistry registry = registries.create(info);
        registry.registerAll("gc", (MetricSet)new GarbageCollectorMetricSet());
        registry.registerAll("memory", (MetricSet)new MemoryUsageGaugeSet());
        registry.registerAll("threads", (MetricSet)new ThreadStatesGaugeSet());
        registry.registerAll("classLoading", (MetricSet)new ClassLoadingGaugeSet());
    }
}

