/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_10.ServerConnection;
import org.apache.qpid.server.protocol.v0_10.ServerDecoder;
import org.apache.qpid.server.protocol.v0_10.ServerFrame;
import org.apache.qpid.server.protocol.v0_10.ServerSession;
import org.apache.qpid.server.protocol.v0_10.transport.DeliveryProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Header;
import org.apache.qpid.server.protocol.v0_10.transport.MessageProperties;
import org.apache.qpid.server.protocol.v0_10.transport.Method;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolError;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolEvent;
import org.apache.qpid.server.protocol.v0_10.transport.ProtocolHeader;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerAssembler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerAssembler.class);
    private final ServerConnection _connection;
    private static final int ARRAY_SIZE = 255;
    private final Method[] _incompleteMethodArray = new Method[256];
    private final Map<Integer, Method> _incompleteMethodMap = new HashMap<Integer, Method>();
    private final Map<Integer, List<ServerFrame>> _segments;

    public ServerAssembler(ServerConnection connection) {
        this._connection = connection;
        this._segments = new HashMap<Integer, List<ServerFrame>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void received(List<ServerFrame> frames) {
        if (!frames.isEmpty()) {
            PeekingIterator itr = Iterators.peekingIterator(frames.iterator());
            boolean cleanExit = false;
            try {
                while (itr.hasNext()) {
                    ServerFrame frame = (ServerFrame)itr.next();
                    int frameChannel = frame.getChannel();
                    ServerSession channel = this._connection.getSession(frameChannel);
                    if (channel != null) {
                        AccessControlContext context = channel.getAccessControllerContext();
                        AccessController.doPrivileged(() -> {
                            boolean nextIsSameChannel;
                            ServerFrame channelFrame = frame;
                            do {
                                this.received(channelFrame);
                                boolean bl = nextIsSameChannel = itr.hasNext() && frameChannel == ((ServerFrame)itr.peek()).getChannel();
                                if (!nextIsSameChannel) continue;
                                channelFrame = (ServerFrame)itr.next();
                            } while (nextIsSameChannel);
                            return null;
                        }, context);
                        continue;
                    }
                    this.received(frame);
                }
                cleanExit = true;
            }
            finally {
                if (!cleanExit) {
                    while (itr.hasNext()) {
                        QpidByteBuffer body = ((ServerFrame)itr.next()).getBody();
                        if (body == null) continue;
                        body.dispose();
                    }
                }
            }
        }
    }

    private void received(ServerFrame event) {
        if (!this._connection.isIgnoreFutureInput()) {
            this.frame(event);
        } else {
            LOGGER.debug("Ignored network event " + event + " as connection is ignoring further input ");
        }
    }

    protected ByteBuffer allocateByteBuffer(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    private int segmentKey(ServerFrame frame) {
        return (frame.getTrack() + 1) * frame.getChannel();
    }

    private List<ServerFrame> getSegment(ServerFrame frame) {
        return this._segments.get(this.segmentKey(frame));
    }

    private void setSegment(ServerFrame frame, List<ServerFrame> segment) {
        int key = this.segmentKey(frame);
        if (this._segments.containsKey(key)) {
            this.error(new ProtocolError(1, "segment in progress: %s", frame));
        }
        this._segments.put(this.segmentKey(frame), segment);
    }

    private void clearSegment(ServerFrame frame) {
        this._segments.remove(this.segmentKey(frame));
    }

    private void emit(int channel, ProtocolEvent event) {
        event.setChannel(channel);
        this._connection.received(event);
    }

    public void exception(Throwable t) {
        this._connection.exception(t);
    }

    public void closed() {
        this._connection.closed();
    }

    public void init(ProtocolHeader header) {
        this.emit(0, header);
    }

    public void error(ProtocolError error) {
        this.emit(0, error);
    }

    public void frame(ServerFrame frame) {
        if (frame.isFirstFrame() && frame.isLastFrame()) {
            this.assemble(frame, frame.getBody());
        } else {
            List<Object> frames;
            if (frame.isFirstFrame()) {
                frames = new ArrayList();
                this.setSegment(frame, frames);
            } else {
                frames = this.getSegment(frame);
            }
            frames.add(frame);
            if (frame.isLastFrame()) {
                this.clearSegment(frame);
                ArrayList<QpidByteBuffer> frameBuffers = new ArrayList<QpidByteBuffer>(frames.size());
                for (ServerFrame serverFrame : frames) {
                    frameBuffers.add(serverFrame.getBody());
                }
                QpidByteBuffer combined = QpidByteBuffer.concatenate(frameBuffers);
                for (QpidByteBuffer buffer : frameBuffers) {
                    buffer.dispose();
                }
                this.assemble(frame, combined);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assemble(ServerFrame frame, QpidByteBuffer frameBuffer) {
        try {
            ServerDecoder dec = new ServerDecoder(frameBuffer);
            int channel = frame.getChannel();
            switch (frame.getType()) {
                case CONTROL: {
                    int controlType = dec.readUint16();
                    Method control = Method.create(controlType);
                    control.read(dec);
                    this.emit(channel, control);
                    return;
                }
                case COMMAND: {
                    int commandType = dec.readUint16();
                    int hdr = dec.readUint16();
                    Method command = Method.create(commandType);
                    command.setSync((1 & hdr) != 0);
                    command.read(dec);
                    if (command.hasPayload() && !frame.isLastSegment()) {
                        this.setIncompleteCommand(channel, command);
                        return;
                    } else {
                        this.emit(channel, command);
                        return;
                    }
                }
                case HEADER: {
                    Method command = this.getIncompleteCommand(channel);
                    ArrayList<Struct> structs = null;
                    DeliveryProperties deliveryProps = null;
                    MessageProperties messageProps = null;
                    while (dec.hasRemaining()) {
                        Struct struct = dec.readStruct32();
                        if (struct instanceof DeliveryProperties && deliveryProps == null) {
                            deliveryProps = (DeliveryProperties)struct;
                            continue;
                        }
                        if (struct instanceof MessageProperties && messageProps == null) {
                            messageProps = (MessageProperties)struct;
                            continue;
                        }
                        if (structs == null) {
                            structs = new ArrayList<Struct>(2);
                        }
                        structs.add(struct);
                    }
                    command.setHeader(new Header(deliveryProps, messageProps, structs));
                    if (!frame.isLastSegment()) return;
                    this.setIncompleteCommand(channel, null);
                    this.emit(channel, command);
                    return;
                }
                case BODY: {
                    Method command = this.getIncompleteCommand(channel);
                    command.setBody(frameBuffer);
                    this.setIncompleteCommand(channel, null);
                    this.emit(channel, command);
                    return;
                }
                default: {
                    throw new IllegalStateException("unknown frame type: " + frame.getType());
                }
            }
        }
        finally {
            frameBuffer.dispose();
        }
    }

    private void setIncompleteCommand(int channelId, Method incomplete) {
        if ((channelId & 0xFF) == channelId) {
            this._incompleteMethodArray[channelId] = incomplete;
        } else if (incomplete != null) {
            this._incompleteMethodMap.put(channelId, incomplete);
        } else {
            this._incompleteMethodMap.remove(channelId);
        }
    }

    private Method getIncompleteCommand(int channelId) {
        if ((channelId & 0xFF) == channelId) {
            return this._incompleteMethodArray[channelId];
        }
        return this._incompleteMethodMap.get(channelId);
    }
}

