package org.apache.pulsar.shade.org.checkerframework.checker.regex.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.InvisibleQualifier;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.SubtypeOf;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.TargetLocations;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.TypeUseLocation;

/**
 * Represents the top of the Regex qualifier hierarchy.
 *
 * @checker_framework.manual #regex-checker Regex Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@TargetLocations({TypeUseLocation.EXPLICIT_LOWER_BOUND, TypeUseLocation.EXPLICIT_UPPER_BOUND})
@InvisibleQualifier
@SubtypeOf({})
@DefaultQualifierInHierarchy
public @interface UnknownRegex {}
