package org.apache.pulsar.shade.org.checkerframework.checker.index.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.DefaultQualifierInHierarchy;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.InvisibleQualifier;
import org.apache.pulsar.shade.org.checkerframework.framework.qual.SubtypeOf;

/**
 * The top type for the SearchIndex type system. This indicates that the Index checker does not know
 * any arrays that this integer is a {@link SearchIndexFor search index} for.
 *
 * @checker_framework.manual #index-checker Index Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf({})
@DefaultQualifierInHierarchy
@InvisibleQualifier
public @interface SearchIndexUnknown {}
