/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.RangeEquallyDivideBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.TopicCountEquallyDivideBundleSplitAlgorithm;

public interface NamespaceBundleSplitAlgorithm {
    public static final String rangeEquallyDivideName = "range_equally_divide";
    public static final String topicCountEquallyDivideName = "topic_count_equally_divide";
    public static final List<String> availableAlgorithms = Lists.newArrayList((Object[])new String[]{"range_equally_divide", "topic_count_equally_divide"});
    public static final NamespaceBundleSplitAlgorithm rangeEquallyDivide = new RangeEquallyDivideBundleSplitAlgorithm();
    public static final NamespaceBundleSplitAlgorithm topicCountEquallyDivide = new TopicCountEquallyDivideBundleSplitAlgorithm();

    public static NamespaceBundleSplitAlgorithm of(String algorithmName) {
        if (algorithmName == null) {
            return null;
        }
        switch (algorithmName) {
            case "range_equally_divide": {
                return rangeEquallyDivide;
            }
            case "topic_count_equally_divide": {
                return topicCountEquallyDivide;
            }
        }
        return null;
    }

    public CompletableFuture<Long> getSplitBoundary(NamespaceService var1, NamespaceBundle var2);
}

