/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.common.naming.TopicName;

public interface SystemTopicClient {
    public TopicName getTopicName();

    public Reader newReader() throws PulsarClientException;

    public CompletableFuture<Reader> newReaderAsync();

    public Writer newWriter() throws PulsarClientException;

    public CompletableFuture<Writer> newWriterAsync();

    public void close() throws Exception;

    public CompletableFuture<Void> closeAsync();

    public List<Writer> getWriters();

    public List<Reader> getReaders();

    public static boolean isSystemTopic(TopicName topicName) {
        return "__change_events".equals(topicName.getLocalName());
    }

    public static interface Reader {
        public Message<PulsarEvent> readNext() throws PulsarClientException;

        public CompletableFuture<Message<PulsarEvent>> readNextAsync();

        public boolean hasMoreEvents() throws PulsarClientException;

        public CompletableFuture<Boolean> hasMoreEventsAsync();

        public void close() throws IOException;

        public CompletableFuture<Void> closeAsync();

        public SystemTopicClient getSystemTopic();
    }

    public static interface Writer {
        public MessageId write(PulsarEvent var1) throws PulsarClientException;

        public CompletableFuture<MessageId> writeAsync(PulsarEvent var1);

        public void close() throws IOException;

        public CompletableFuture<Void> closeAsync();

        public SystemTopicClient getSystemTopicClient();
    }
}

