/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.metrics;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.AbstractMetrics;
import org.apache.pulsar.common.stats.Metrics;

public class ManagedLedgerMetrics
extends AbstractMetrics {
    private List<Metrics> metricsCollection = Lists.newArrayList();
    private Map<Metrics, List<ManagedLedgerImpl>> ledgersByDimensionMap = Maps.newHashMap();
    private Map<String, Double> tempAggregatedMetricsMap = Maps.newHashMap();

    public ManagedLedgerMetrics(PulsarService pulsar) {
        super(pulsar);
    }

    @Override
    public synchronized List<Metrics> generate() {
        return this.aggregate(this.groupLedgersByDimension());
    }

    private List<Metrics> aggregate(Map<Metrics, List<ManagedLedgerImpl>> ledgersByDimension) {
        this.metricsCollection.clear();
        for (Map.Entry<Metrics, List<ManagedLedgerImpl>> e : ledgersByDimension.entrySet()) {
            Metrics metrics = e.getKey();
            List<ManagedLedgerImpl> ledgers = e.getValue();
            this.tempAggregatedMetricsMap.clear();
            for (ManagedLedgerImpl managedLedgerImpl : ledgers) {
                ManagedLedgerMXBean lStats = managedLedgerImpl.getStats();
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntryBytesRate", lStats.getAddEntryBytesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntryErrors", lStats.getAddEntryErrors());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntryMessagesRate", lStats.getAddEntryMessagesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_AddEntrySucceed", lStats.getAddEntrySucceed());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_NumberOfMessagesInBacklog", lStats.getNumberOfMessagesInBacklog());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesBytesRate", lStats.getReadEntriesBytesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesErrors", lStats.getReadEntriesErrors());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesRate", lStats.getReadEntriesRate());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_ReadEntriesSucceeded", lStats.getReadEntriesSucceeded());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_StoredMessagesSize", lStats.getStoredMessagesSize());
                this.populateBucketEntries(this.tempAggregatedMetricsMap, "brk_ml_AddEntryLatencyBuckets", ENTRY_LATENCY_BUCKETS_MS, lStats.getAddEntryLatencyBuckets());
                this.populateBucketEntries(this.tempAggregatedMetricsMap, "brk_ml_LedgerSwitchLatencyBuckets", ENTRY_LATENCY_BUCKETS_MS, lStats.getLedgerSwitchLatencyBuckets());
                this.populateBucketEntries(this.tempAggregatedMetricsMap, "brk_ml_EntrySizeBuckets", ENTRY_SIZE_BUCKETS_BYTES, lStats.getEntrySizeBuckets());
                this.populateAggregationMapWithSum(this.tempAggregatedMetricsMap, "brk_ml_MarkDeleteRate", lStats.getMarkDeleteRate());
            }
            for (Map.Entry entry : this.tempAggregatedMetricsMap.entrySet()) {
                metrics.put((String)entry.getKey(), entry.getValue());
            }
            this.metricsCollection.add(metrics);
        }
        return this.metricsCollection;
    }

    private Map<Metrics, List<ManagedLedgerImpl>> groupLedgersByDimension() {
        this.ledgersByDimensionMap.clear();
        for (Map.Entry<String, ManagedLedgerImpl> e : this.getManagedLedgers().entrySet()) {
            String ledgerName = e.getKey();
            ManagedLedgerImpl ledger = e.getValue();
            String namespace = this.parseNamespaceFromLedgerName(ledgerName);
            Metrics metrics = this.createMetricsByDimension(namespace);
            this.populateDimensionMap(this.ledgersByDimensionMap, metrics, ledger);
        }
        return this.ledgersByDimensionMap;
    }
}

