/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup;

import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.common.lookup.data.LookupData;

public class LookupResult {
    private final Type type;
    private final LookupData lookupData;
    private final boolean authoritativeRedirect;

    public LookupResult(NamespaceEphemeralData namespaceEphemeralData) {
        this.type = Type.BrokerUrl;
        this.authoritativeRedirect = false;
        this.lookupData = new LookupData(namespaceEphemeralData.getNativeUrl(), namespaceEphemeralData.getNativeUrlTls(), namespaceEphemeralData.getHttpUrl(), namespaceEphemeralData.getHttpUrlTls());
    }

    public LookupResult(String httpUrl, String httpUrlTls, String brokerServiceUrl, String brokerServiceUrlTls, boolean authoritativeRedirect) {
        this.type = Type.RedirectUrl;
        this.authoritativeRedirect = authoritativeRedirect;
        this.lookupData = new LookupData(brokerServiceUrl, brokerServiceUrlTls, httpUrl, httpUrlTls);
    }

    public LookupResult(String httpUrl, String httpUrlTls, String nativeUrl, String nativeUrlTls, Type type, boolean authoritativeRedirect) {
        this.type = type;
        this.authoritativeRedirect = authoritativeRedirect;
        this.lookupData = new LookupData(nativeUrl, nativeUrlTls, httpUrl, httpUrlTls);
    }

    public LookupResult(NamespaceEphemeralData namespaceEphemeralData, String nativeUrl, String nativeUrlTls) {
        this.type = Type.BrokerUrl;
        this.authoritativeRedirect = false;
        this.lookupData = new LookupData(nativeUrl, nativeUrlTls, namespaceEphemeralData.getHttpUrl(), namespaceEphemeralData.getHttpUrlTls());
    }

    public boolean isBrokerUrl() {
        return this.type == Type.BrokerUrl;
    }

    public boolean isRedirect() {
        return this.type == Type.RedirectUrl;
    }

    public boolean isAuthoritativeRedirect() {
        return this.authoritativeRedirect;
    }

    public LookupData getLookupData() {
        return this.lookupData;
    }

    public String toString() {
        return "LookupResult [type=" + (Object)((Object)this.type) + ", lookupData=" + this.lookupData + "]";
    }

    public static enum Type {
        BrokerUrl,
        RedirectUrl;

    }
}

