/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;

public class GenericBrokerHostUsageImpl
implements BrokerHostUsage {
    private static final int CPU_CHECK_MILLIS = 1000;
    private double totalCpuLimit;
    private double cpuUsageSum = 0.0;
    private int cpuUsageCount = 0;
    private OperatingSystemMXBean systemBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private SystemResourceUsage usage = new SystemResourceUsage();

    public GenericBrokerHostUsageImpl(PulsarService pulsar) {
        this(pulsar.getConfiguration().getLoadBalancerHostUsageCheckIntervalMinutes(), pulsar.getLoadManagerExecutor());
    }

    public GenericBrokerHostUsageImpl(int hostUsageCheckIntervalMin, ScheduledExecutorService executorService) {
        this.totalCpuLimit = this.getTotalCpuLimit();
        executorService.scheduleAtFixedRate(this::checkCpuLoad, 0L, 1000L, TimeUnit.MILLISECONDS);
        executorService.scheduleAtFixedRate(this::doCalculateBrokerHostUsage, 0L, hostUsageCheckIntervalMin, TimeUnit.MINUTES);
    }

    @Override
    public SystemResourceUsage getBrokerHostUsage() {
        return this.usage;
    }

    private void checkCpuLoad() {
        this.cpuUsageSum += this.systemBean.getSystemCpuLoad();
        ++this.cpuUsageCount;
    }

    @Override
    public void calculateBrokerHostUsage() {
        this.checkCpuLoad();
        this.doCalculateBrokerHostUsage();
    }

    void doCalculateBrokerHostUsage() {
        SystemResourceUsage usage = new SystemResourceUsage();
        usage.setCpu(this.getCpuUsage());
        usage.setMemory(this.getMemUsage());
        this.usage = usage;
    }

    private double getTotalCpuLimit() {
        return 100 * Runtime.getRuntime().availableProcessors();
    }

    private double getTotalCpuUsage() {
        double cpuUsage = this.cpuUsageSum / (double)this.cpuUsageCount;
        this.cpuUsageSum = 0.0;
        this.cpuUsageCount = 0;
        return cpuUsage;
    }

    private ResourceUsage getCpuUsage() {
        if (this.cpuUsageCount == 0) {
            return new ResourceUsage(0.0, this.totalCpuLimit);
        }
        return new ResourceUsage(this.getTotalCpuUsage() * this.totalCpuLimit, this.totalCpuLimit);
    }

    private ResourceUsage getMemUsage() {
        double total = (double)this.systemBean.getTotalPhysicalMemorySize() / 1048576.0;
        double free = (double)this.systemBean.getFreePhysicalMemorySize() / 1048576.0;
        return new ResourceUsage(total - free, total);
    }
}

