/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.ModularLoadManager;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerWrapper;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.policies.data.loadbalancer.ServiceLookupData;
import org.apache.pulsar.zookeeper.ZooKeeperCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LoadManager {
    public static final Logger log = LoggerFactory.getLogger(LoadManager.class);
    public static final String LOADBALANCE_BROKERS_ROOT = "/loadbalance/brokers";

    public void start() throws PulsarServerException;

    public boolean isCentralized();

    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId var1) throws Exception;

    public LoadManagerReport generateLoadReport() throws Exception;

    public ZooKeeperCache.Deserializer<? extends ServiceLookupData> getLoadReportDeserializer();

    public void setLoadReportForceUpdateFlag();

    public void writeLoadReportOnZookeeper() throws Exception;

    public void writeResourceQuotasToZooKeeper() throws Exception;

    public List<Metrics> getLoadBalancingMetrics();

    public void doLoadShedding();

    public void doNamespaceBundleSplit() throws Exception;

    public void disableBroker() throws Exception;

    public Set<String> getAvailableBrokers() throws Exception;

    public void stop() throws PulsarServerException;

    public void initialize(PulsarService var1);

    public static LoadManager create(PulsarService pulsar) {
        try {
            ServiceConfiguration conf = pulsar.getConfiguration();
            Class<?> loadManagerClass = Class.forName(conf.getLoadManagerClassName());
            Object loadManagerInstance = loadManagerClass.newInstance();
            if (loadManagerInstance instanceof LoadManager) {
                LoadManager casted = (LoadManager)loadManagerInstance;
                casted.initialize(pulsar);
                return casted;
            }
            if (loadManagerInstance instanceof ModularLoadManager) {
                ModularLoadManagerWrapper casted = new ModularLoadManagerWrapper((ModularLoadManager)loadManagerInstance);
                casted.initialize(pulsar);
                return casted;
            }
        }
        catch (Exception e) {
            log.warn("Error when trying to create load manager: ", (Throwable)e);
        }
        return new SimpleLoadManagerImpl(pulsar);
    }
}

