/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.worker;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.NamedThreadFactory;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.query.runtime.QueryRunner;
import org.apache.pinot.query.service.QueryServer;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.CommonConstants;
import org.apache.pinot.spi.utils.NetUtils;

public class WorkerQueryServer {
    private static final int DEFAULT_EXECUTOR_THREAD_NUM = 5;
    private final ExecutorService _executor;
    private final int _queryServicePort;
    private final PinotConfiguration _configuration;
    private final HelixManager _helixManager;
    private QueryServer _queryWorkerService;
    private QueryRunner _queryRunner;
    private InstanceDataManager _instanceDataManager;
    private ServerMetrics _serverMetrics;

    public WorkerQueryServer(PinotConfiguration configuration, InstanceDataManager instanceDataManager, HelixManager helixManager, ServerMetrics serverMetrics) {
        this._configuration = WorkerQueryServer.toWorkerQueryConfig(configuration);
        this._helixManager = helixManager;
        this._instanceDataManager = instanceDataManager;
        this._serverMetrics = serverMetrics;
        this._queryServicePort = this._configuration.getProperty("pinot.query.server.port", 0);
        this._queryRunner = new QueryRunner();
        this._queryRunner.init(this._configuration, this._instanceDataManager, this._helixManager, this._serverMetrics);
        this._queryWorkerService = new QueryServer(this._queryServicePort, this._queryRunner);
        this._executor = Executors.newFixedThreadPool(5, (ThreadFactory)new NamedThreadFactory("worker_query_server_enclosure_on_" + this._queryServicePort + "_port"));
    }

    private static PinotConfiguration toWorkerQueryConfig(PinotConfiguration configuration) {
        int servicePort;
        int runnerPort;
        PinotConfiguration newConfig = new PinotConfiguration(configuration.toMap());
        String hostname = newConfig.getProperty("pinot.query.runner.hostname");
        if (hostname == null) {
            String instanceId = newConfig.getProperty("pinot.server.netty.host", NetUtils.getHostnameOrAddress());
            hostname = instanceId.startsWith("Server_") ? instanceId.substring(CommonConstants.Helix.SERVER_INSTANCE_PREFIX_LENGTH) : instanceId;
            newConfig.addProperty("pinot.query.runner.hostname", (Object)hostname);
        }
        if ((runnerPort = newConfig.getProperty("pinot.query.runner.port", 0)) == -1) {
            runnerPort = newConfig.getProperty("pinot.server.grpc.port", 8090);
            newConfig.addProperty("pinot.query.runner.port", (Object)runnerPort);
        }
        if ((servicePort = newConfig.getProperty("pinot.query.server.port", 0)) == -1) {
            servicePort = newConfig.getProperty("pinot.server.netty.port", 8098);
            newConfig.addProperty("pinot.query.server.port", (Object)servicePort);
        }
        return newConfig;
    }

    public int getPort() {
        return this._queryServicePort;
    }

    public void start() {
        try {
            this._queryWorkerService.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutDown() {
        this._queryWorkerService.shutdown();
        this._executor.shutdown();
    }
}

