/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import com.google.common.base.Preconditions;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelFactory;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.SegmentName;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentOnlineOfflineStateModelFactory
extends StateModelFactory<StateModel> {
    private final String _instanceId;
    private final InstanceDataManager _instanceDataManager;

    public SegmentOnlineOfflineStateModelFactory(String instanceId, InstanceDataManager instanceDataManager) {
        this._instanceId = instanceId;
        this._instanceDataManager = instanceDataManager;
    }

    public static String getStateModelName() {
        return "SegmentOnlineOfflineStateModel";
    }

    public StateModel createNewStateModel(String resourceName, String partitionName) {
        return new SegmentOnlineOfflineStateModel();
    }

    @StateModelInfo(states={"{'OFFLINE','ONLINE', 'CONSUMING', 'DROPPED'}"}, initialState="OFFLINE")
    public class SegmentOnlineOfflineStateModel
    extends StateModel {
        private final Logger _logger;

        public SegmentOnlineOfflineStateModel() {
            this._logger = LoggerFactory.getLogger((String)(SegmentOnlineOfflineStateModelFactory.this._instanceId + " - " + ((Object)((Object)this)).getClass().getName()));
        }

        @Transition(from="OFFLINE", to="CONSUMING")
        public void onBecomeConsumingFromOffline(Message message, NotificationContext context) {
            Preconditions.checkState((boolean)SegmentName.isLowLevelConsumerSegmentName((String)message.getPartitionName()), (Object)"Tried to go into CONSUMING state on non-low level segment");
            this._logger.info("SegmentOnlineOfflineStateModel.onBecomeConsumingFromOffline() : " + message);
            this.onBecomeOnlineFromOffline(message, context);
        }

        @Transition(from="CONSUMING", to="ONLINE")
        public void onBecomeOnlineFromConsuming(Message message, NotificationContext context) {
            String realtimeTableName = message.getResourceName();
            String segmentNameStr = message.getPartitionName();
            LLCSegmentName segmentName = new LLCSegmentName(segmentNameStr);
            TableDataManager tableDataManager = SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.getTableDataManager(realtimeTableName);
            Preconditions.checkNotNull((Object)tableDataManager);
            SegmentDataManager acquiredSegment = tableDataManager.acquireSegment(segmentNameStr);
            if (acquiredSegment == null) {
                throw new RuntimeException("Segment " + segmentNameStr + " + not present ");
            }
            try {
                if (!(acquiredSegment instanceof LLRealtimeSegmentDataManager)) {
                    this._logger.info("Segment {} not an instance of LLRealtimeSegmentDataManager. Reporting success for the transition", (Object)acquiredSegment.getSegmentName());
                    return;
                }
                LLRealtimeSegmentDataManager segmentDataManager = (LLRealtimeSegmentDataManager)acquiredSegment;
                SegmentZKMetadata segmentZKMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore)SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.getPropertyStore(), (String)realtimeTableName, (String)segmentNameStr);
                segmentDataManager.goOnlineFromConsuming(segmentZKMetadata);
            }
            catch (InterruptedException e) {
                String errorMessage = String.format("State transition interrupted for segment %s.", segmentNameStr);
                this._logger.warn(errorMessage, (Throwable)e);
                tableDataManager.addSegmentError(segmentNameStr, new SegmentErrorInfo(System.currentTimeMillis(), errorMessage, (Exception)e));
                throw new RuntimeException(e);
            }
            finally {
                tableDataManager.releaseSegment(acquiredSegment);
            }
        }

        @Transition(from="CONSUMING", to="OFFLINE")
        public void onBecomeOfflineFromConsuming(Message message, NotificationContext context) {
            this._logger.info("SegmentOnlineOfflineStateModel.onBecomeOfflineFromConsuming() : " + message);
            String realtimeTableName = message.getResourceName();
            String segmentName = message.getPartitionName();
            try {
                SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.offloadSegment(realtimeTableName, segmentName);
            }
            catch (Exception e) {
                this._logger.error("Caught exception in state transition from CONSUMING -> OFFLINE for resource: {}, partition: {}", new Object[]{realtimeTableName, segmentName, e});
                Utils.rethrowException((Throwable)e);
            }
        }

        @Transition(from="CONSUMING", to="DROPPED")
        public void onBecomeDroppedFromConsuming(Message message, NotificationContext context) {
            this._logger.info("SegmentOnlineOfflineStateModel.onBecomeDroppedFromConsuming() : " + message);
            try {
                this.onBecomeOfflineFromConsuming(message, context);
                this.onBecomeDroppedFromOffline(message, context);
            }
            catch (Exception e) {
                this._logger.error("Caught exception on CONSUMING -> DROPPED state transition", (Throwable)e);
                Utils.rethrowException((Throwable)e);
            }
        }

        @Transition(from="OFFLINE", to="ONLINE")
        public void onBecomeOnlineFromOffline(Message message, NotificationContext context) {
            this._logger.info("SegmentOnlineOfflineStateModel.onBecomeOnlineFromOffline() : " + message);
            String tableNameWithType = message.getResourceName();
            String segmentName = message.getPartitionName();
            try {
                TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)message.getResourceName());
                Preconditions.checkNotNull((Object)tableType);
                if (tableType == TableType.OFFLINE) {
                    SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.addOrReplaceSegment(tableNameWithType, segmentName);
                } else {
                    SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.addRealtimeSegment(tableNameWithType, segmentName);
                }
            }
            catch (Exception e) {
                String errorMessage = String.format("Caught exception in state transition from OFFLINE -> ONLINE for resource: %s, partition: %s", tableNameWithType, segmentName);
                this._logger.error(errorMessage, (Throwable)e);
                TableDataManager tableDataManager = SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.getTableDataManager(tableNameWithType);
                if (tableDataManager != null) {
                    tableDataManager.addSegmentError(segmentName, new SegmentErrorInfo(System.currentTimeMillis(), errorMessage, e));
                }
                Utils.rethrowException((Throwable)e);
            }
        }

        @Transition(from="ONLINE", to="OFFLINE")
        public void onBecomeOfflineFromOnline(Message message, NotificationContext context) {
            this._logger.info("SegmentOnlineOfflineStateModel.onBecomeOfflineFromOnline() : " + message);
            String tableNameWithType = message.getResourceName();
            String segmentName = message.getPartitionName();
            try {
                SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.offloadSegment(tableNameWithType, segmentName);
            }
            catch (Exception e) {
                this._logger.error("Caught exception in state transition from ONLINE -> OFFLINE for resource: {}, partition: {}", new Object[]{tableNameWithType, segmentName, e});
                Utils.rethrowException((Throwable)e);
            }
        }

        @Transition(from="OFFLINE", to="DROPPED")
        public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
            this._logger.info("SegmentOnlineOfflineStateModel.onBecomeDroppedFromOffline() : " + message);
            String tableNameWithType = message.getResourceName();
            String segmentName = message.getPartitionName();
            try {
                SegmentOnlineOfflineStateModelFactory.this._instanceDataManager.deleteSegment(tableNameWithType, segmentName);
            }
            catch (Exception e) {
                this._logger.error("Cannot drop the segment : " + segmentName + " from server!\n" + e.getMessage(), (Throwable)e);
                Utils.rethrowException((Throwable)e);
            }
        }

        @Transition(from="ONLINE", to="DROPPED")
        public void onBecomeDroppedFromOnline(Message message, NotificationContext context) {
            this._logger.info("SegmentOnlineOfflineStateModel.onBecomeDroppedFromOnline() : " + message);
            try {
                this.onBecomeOfflineFromOnline(message, context);
                this.onBecomeDroppedFromOffline(message, context);
            }
            catch (Exception e) {
                this._logger.error("Caught exception on ONLINE -> DROPPED state transition", (Throwable)e);
                Utils.rethrowException((Throwable)e);
            }
        }

        @Transition(from="ERROR", to="OFFLINE")
        public void onBecomeOfflineFromError(Message message, NotificationContext context) {
            this._logger.info("Resetting the state for segment:{} from ERROR to OFFLINE", (Object)message.getPartitionName());
        }
    }
}

