/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.model.Message;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.messages.ForceCommitMessage;
import org.apache.pinot.common.messages.SegmentRefreshMessage;
import org.apache.pinot.common.messages.SegmentReloadMessage;
import org.apache.pinot.common.messages.TableDeletionMessage;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.util.SegmentRefreshSemaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMessageHandlerFactory
implements MessageHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentMessageHandlerFactory.class);
    private final InstanceDataManager _instanceDataManager;
    private final ServerMetrics _metrics;
    private final SegmentRefreshSemaphore _segmentRefreshSemaphore;

    public SegmentMessageHandlerFactory(InstanceDataManager instanceDataManager, ServerMetrics metrics) {
        this._instanceDataManager = instanceDataManager;
        this._metrics = metrics;
        this._segmentRefreshSemaphore = new SegmentRefreshSemaphore(instanceDataManager.getMaxParallelRefreshThreads(), true);
    }

    public MessageHandler createHandler(Message message, NotificationContext context) {
        String msgSubType;
        switch (msgSubType = message.getMsgSubType()) {
            case "REFRESH_SEGMENT": {
                return new SegmentRefreshMessageHandler(new SegmentRefreshMessage(message), this._metrics, context);
            }
            case "RELOAD_SEGMENT": {
                return new SegmentReloadMessageHandler(new SegmentReloadMessage(message), this._metrics, context);
            }
            case "DELETE_TABLE": {
                return new TableDeletionMessageHandler(new TableDeletionMessage(message), this._metrics, context);
            }
            case "FORCE_COMMIT": {
                return new ForceCommitMessageHandler(new ForceCommitMessage(message), this._metrics, context);
            }
        }
        LOGGER.warn("Unsupported user defined message sub type: {} for segment: {}", (Object)msgSubType, (Object)message.getPartitionName());
        return new DefaultMessageHandler(message, this._metrics, context);
    }

    public String getMessageType() {
        return Message.MessageType.USER_DEFINE_MSG.toString();
    }

    public void reset() {
        LOGGER.info("Reset called");
    }

    private static class DefaultMessageHandler
    extends MessageHandler {
        final String _segmentName;
        final String _tableNameWithType;
        final ServerMetrics _metrics;
        final Logger _logger;

        DefaultMessageHandler(Message message, ServerMetrics metrics, NotificationContext context) {
            super(message, context);
            this._segmentName = message.getPartitionName();
            this._tableNameWithType = message.getResourceName();
            this._metrics = metrics;
            this._logger = LoggerFactory.getLogger((String)(this._tableNameWithType + "-" + ((Object)((Object)this)).getClass().getSimpleName()));
        }

        public HelixTaskResult handleMessage() throws InterruptedException {
            HelixTaskResult helixTaskResult = new HelixTaskResult();
            helixTaskResult.setSuccess(true);
            return helixTaskResult;
        }

        public void onError(Exception e, MessageHandler.ErrorCode errorCode, MessageHandler.ErrorType errorType) {
            this._logger.error("onError: {}, {}", new Object[]{errorType, errorCode, e});
        }
    }

    private class ForceCommitMessageHandler
    extends DefaultMessageHandler {
        private String _tableName;
        private Set<String> _segmentNames;

        public ForceCommitMessageHandler(ForceCommitMessage forceCommitMessage, ServerMetrics metrics, NotificationContext ctx) {
            super((Message)forceCommitMessage, metrics, ctx);
            this._tableName = forceCommitMessage.getTableName();
            this._segmentNames = forceCommitMessage.getSegmentNames();
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            HelixTaskResult helixTaskResult = new HelixTaskResult();
            this._logger.info("Handling force commit message for table {} segments {}", (Object)this._tableName, this._segmentNames);
            try {
                SegmentMessageHandlerFactory.this._instanceDataManager.forceCommit(this._tableName, this._segmentNames);
                helixTaskResult.setSuccess(true);
            }
            catch (Exception e) {
                this._metrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.DELETE_TABLE_FAILURES, 1L);
                Utils.rethrowException((Throwable)e);
            }
            return helixTaskResult;
        }
    }

    private class TableDeletionMessageHandler
    extends DefaultMessageHandler {
        TableDeletionMessageHandler(TableDeletionMessage tableDeletionMessage, ServerMetrics metrics, NotificationContext context) {
            super((Message)tableDeletionMessage, metrics, context);
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            HelixTaskResult helixTaskResult = new HelixTaskResult();
            this._logger.info("Handling table deletion message");
            try {
                SegmentMessageHandlerFactory.this._instanceDataManager.deleteTable(this._tableNameWithType);
                helixTaskResult.setSuccess(true);
            }
            catch (Exception e) {
                this._metrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.DELETE_TABLE_FAILURES, 1L);
                Utils.rethrowException((Throwable)e);
            }
            return helixTaskResult;
        }
    }

    private class SegmentReloadMessageHandler
    extends DefaultMessageHandler {
        private final boolean _forceDownload;
        private final List<String> _segmentList;

        SegmentReloadMessageHandler(SegmentReloadMessage segmentReloadMessage, ServerMetrics metrics, NotificationContext context) {
            super((Message)segmentReloadMessage, metrics, context);
            this._forceDownload = segmentReloadMessage.shouldForceDownload();
            this._segmentList = segmentReloadMessage.getSegmentList();
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            HelixTaskResult helixTaskResult = new HelixTaskResult();
            this._logger.info("Handling message: {}", (Object)this._message);
            try {
                if (CollectionUtils.isNotEmpty(this._segmentList)) {
                    SegmentMessageHandlerFactory.this._instanceDataManager.reloadSegments(this._tableNameWithType, this._segmentList, this._forceDownload, SegmentMessageHandlerFactory.this._segmentRefreshSemaphore);
                } else if (StringUtils.isNotEmpty((CharSequence)this._segmentName)) {
                    SegmentMessageHandlerFactory.this._segmentRefreshSemaphore.acquireSema(this._segmentName, this._logger);
                    try {
                        SegmentMessageHandlerFactory.this._instanceDataManager.reloadSegment(this._tableNameWithType, this._segmentName, this._forceDownload);
                    }
                    finally {
                        SegmentMessageHandlerFactory.this._segmentRefreshSemaphore.releaseSema();
                    }
                } else {
                    SegmentMessageHandlerFactory.this._instanceDataManager.reloadAllSegments(this._tableNameWithType, this._forceDownload, SegmentMessageHandlerFactory.this._segmentRefreshSemaphore);
                }
                helixTaskResult.setSuccess(true);
            }
            catch (Throwable e) {
                this._metrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.RELOAD_FAILURES, 1L);
                throw new RuntimeException("Caught exception while reloading segment: " + this._segmentName + " in table: " + this._tableNameWithType, e);
            }
            return helixTaskResult;
        }
    }

    private class SegmentRefreshMessageHandler
    extends DefaultMessageHandler {
        SegmentRefreshMessageHandler(SegmentRefreshMessage refreshMessage, ServerMetrics metrics, NotificationContext context) {
            super((Message)refreshMessage, metrics, context);
        }

        @Override
        public HelixTaskResult handleMessage() throws InterruptedException {
            HelixTaskResult result = new HelixTaskResult();
            this._logger.info("Handling message: {}", (Object)this._message);
            try {
                SegmentMessageHandlerFactory.this._segmentRefreshSemaphore.acquireSema(this._segmentName, this._logger);
                SegmentMessageHandlerFactory.this._instanceDataManager.addOrReplaceSegment(this._tableNameWithType, this._segmentName);
                result.setSuccess(true);
            }
            catch (Exception e) {
                this._metrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.REFRESH_FAILURES, 1L);
                Utils.rethrowException((Throwable)e);
            }
            finally {
                SegmentMessageHandlerFactory.this._segmentRefreshSemaphore.releaseSema();
            }
            return result;
        }
    }
}

