/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IngestionBasedConsumptionStatusChecker {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    protected final InstanceDataManager _instanceDataManager;
    protected final Set<String> _consumingSegments;
    private final Set<String> _caughtUpSegments = new HashSet<String>();

    public IngestionBasedConsumptionStatusChecker(InstanceDataManager instanceDataManager, Set<String> consumingSegments) {
        this._instanceDataManager = instanceDataManager;
        this._consumingSegments = consumingSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumConsumingSegmentsNotReachedIngestionCriteria() {
        for (String segName : this._consumingSegments) {
            if (this._caughtUpSegments.contains(segName)) continue;
            TableDataManager tableDataManager = this.getTableDataManager(segName);
            if (tableDataManager == null) {
                this._logger.info("TableDataManager is not yet setup for segment {}. Will check consumption status later", (Object)segName);
                continue;
            }
            SegmentDataManager segmentDataManager = null;
            try {
                segmentDataManager = tableDataManager.acquireSegment(segName);
                if (segmentDataManager == null) {
                    this._logger.info("SegmentDataManager is not yet setup for segment {}. Will check consumption status later", (Object)segName);
                    continue;
                }
                if (!(segmentDataManager instanceof LLRealtimeSegmentDataManager)) {
                    this._logger.info("Segment {} is already committed and is considered caught up.", (Object)segName);
                    this._caughtUpSegments.add(segName);
                    continue;
                }
                LLRealtimeSegmentDataManager rtSegmentDataManager = (LLRealtimeSegmentDataManager)segmentDataManager;
                if (!this.isSegmentCaughtUp(segName, rtSegmentDataManager)) continue;
                this._caughtUpSegments.add(segName);
            }
            finally {
                if (segmentDataManager == null) continue;
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        return this._consumingSegments.size() - this._caughtUpSegments.size();
    }

    protected abstract boolean isSegmentCaughtUp(String var1, LLRealtimeSegmentDataManager var2);

    private TableDataManager getTableDataManager(String segmentName) {
        LLCSegmentName llcSegmentName = new LLCSegmentName(segmentName);
        String tableName = llcSegmentName.getTableName();
        String tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(tableName);
        return this._instanceDataManager.getTableDataManager(tableNameWithType);
    }
}

