/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import java.util.Optional;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelixInstanceDataManagerConfig
implements InstanceDataManagerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelixInstanceDataManagerConfig.class);
    private static final String AVERAGE_MV_COUNT = "realtime.averageMultiValueEntriesPerRow";
    public static final String INSTANCE_ID = "id";
    public static final String INSTANCE_DATA_DIR = "dataDir";
    public static final String CONSUMER_DIR = "consumerDir";
    public static final String INSTANCE_SEGMENT_TAR_DIR = "segmentTarDir";
    public static final String INSTANCE_BOOTSTRAP_SEGMENT_DIR = "bootstrap.segment.dir";
    public static final String kEY_OF_TABLE_DATA_DIRECTORY = "directory";
    public static final String kEY_OF_TABLE_NAME = "name";
    public static final String READ_MODE = "readMode";
    public static final String SEGMENT_FORMAT_VERSION = "segment.format.version";
    public static final String INSTANCE_RELOAD_CONSUMING_SEGMENT = "reload.consumingSegment";
    public static final String SEGMENT_DIRECTORY_LOADER = "segment.directory.loader";
    private static final String MAX_PARALLEL_SEGMENT_BUILDS = "realtime.max.parallel.segment.builds";
    private static final int DEFAULT_MAX_PARALLEL_SEGMENT_BUILDS = 4;
    private static final String MAX_PARALLEL_SEGMENT_DOWNLOADS = "table.level.max.parallel.segment.downloads";
    private static final int DEFAULT_MAX_PARALLEL_SEGMENT_DOWNLOADS = -1;
    private static final String STREAM_SEGMENT_DOWNLOAD_UNTAR_RATE_LIMIT = "segment.stream.download.untar.rate.limit.bytes.per.sec";
    private static final long DEFAULT_STREAM_SEGMENT_DOWNLOAD_UNTAR_RATE_LIMIT = -1L;
    private static final String ENABLE_STREAM_SEGMENT_DOWNLOAD_UNTAR = "segment.stream.download.untar";
    private static final boolean DEFAULT_ENABLE_STREAM_SEGMENT_DOWNLOAD_UNTAR = false;
    private static final String ENABLE_SPLIT_COMMIT = "enable.split.commit";
    private static final String ENABLE_SPLIT_COMMIT_END_WITH_METADATA = "enable.commitend.metadata";
    private static final String REALTIME_OFFHEAP_ALLOCATION = "realtime.alloc.offheap";
    private static final String DIRECT_REALTIME_OFFHEAP_ALLOCATION = "realtime.alloc.offheap.direct";
    private static final String MAX_PARALLEL_REFRESH_THREADS = "max.parallel.refresh.threads";
    private static final String ERROR_CACHE_SIZE = "error.cache.size";
    private static final String DELETED_SEGMENTS_CACHE_SIZE = "table.deleted.segments.cache.size";
    private static final String DELETED_SEGMENTS_CACHE_TTL_MINUTES = "table.deleted.segments.cache.ttl.minutes";
    private static final String PEER_DOWNLOAD_SCHEME = "peer.download.scheme";
    private static final String[] REQUIRED_KEYS = new String[]{"id", "dataDir", "readMode"};
    private static final long DEFAULT_ERROR_CACHE_SIZE = 100L;
    private static final int DEFAULT_DELETED_SEGMENTS_CACHE_SIZE = 10000;
    private static final int DEFAULT_DELETED_SEGMENTS_CACHE_TTL_MINUTES = 2;
    private PinotConfiguration _instanceDataManagerConfiguration = null;

    public HelixInstanceDataManagerConfig(PinotConfiguration serverConfig) throws ConfigurationException {
        this._instanceDataManagerConfiguration = serverConfig;
        for (String key : serverConfig.getKeys()) {
            LOGGER.info("InstanceDataManagerConfig, key: {} , value: {}", (Object)key, (Object)serverConfig.getProperty(key));
        }
        this.checkRequiredKeys();
    }

    private void checkRequiredKeys() throws ConfigurationException {
        for (String keyString : REQUIRED_KEYS) {
            Optional.ofNullable(this._instanceDataManagerConfiguration.getProperty(keyString)).orElseThrow(() -> new ConfigurationException("Cannot find required key : " + keyString));
        }
    }

    public PinotConfiguration getConfig() {
        return this._instanceDataManagerConfiguration;
    }

    public String getInstanceId() {
        return this._instanceDataManagerConfiguration.getProperty(INSTANCE_ID);
    }

    public String getInstanceDataDir() {
        return this._instanceDataManagerConfiguration.getProperty(INSTANCE_DATA_DIR);
    }

    public String getConsumerDir() {
        return this._instanceDataManagerConfiguration.getProperty(CONSUMER_DIR);
    }

    public String getInstanceSegmentTarDir() {
        return this._instanceDataManagerConfiguration.getProperty(INSTANCE_SEGMENT_TAR_DIR);
    }

    public String getInstanceBootstrapSegmentDir() {
        return this._instanceDataManagerConfiguration.getProperty(INSTANCE_BOOTSTRAP_SEGMENT_DIR);
    }

    public String getSegmentStoreUri() {
        return this._instanceDataManagerConfiguration.getProperty("segment.store.uri");
    }

    public ReadMode getReadMode() {
        return ReadMode.valueOf((String)this._instanceDataManagerConfiguration.getProperty(READ_MODE));
    }

    public String getSegmentFormatVersion() {
        return this._instanceDataManagerConfiguration.getProperty(SEGMENT_FORMAT_VERSION);
    }

    public boolean isEnableSplitCommit() {
        return this._instanceDataManagerConfiguration.getProperty(ENABLE_SPLIT_COMMIT, true);
    }

    public boolean isEnableSplitCommitEndWithMetadata() {
        return this._instanceDataManagerConfiguration.getProperty(ENABLE_SPLIT_COMMIT_END_WITH_METADATA, true);
    }

    public boolean isRealtimeOffHeapAllocation() {
        return this._instanceDataManagerConfiguration.getProperty(REALTIME_OFFHEAP_ALLOCATION, true);
    }

    public boolean isDirectRealtimeOffHeapAllocation() {
        return this._instanceDataManagerConfiguration.getProperty(DIRECT_REALTIME_OFFHEAP_ALLOCATION, false);
    }

    public boolean shouldReloadConsumingSegment() {
        return this._instanceDataManagerConfiguration.getProperty(INSTANCE_RELOAD_CONSUMING_SEGMENT, true);
    }

    public String getAvgMultiValueCount() {
        return this._instanceDataManagerConfiguration.getProperty(AVERAGE_MV_COUNT);
    }

    public int getMaxParallelRefreshThreads() {
        return this._instanceDataManagerConfiguration.getProperty(MAX_PARALLEL_REFRESH_THREADS, 1);
    }

    public int getMaxParallelSegmentBuilds() {
        return this._instanceDataManagerConfiguration.getProperty(MAX_PARALLEL_SEGMENT_BUILDS, 4);
    }

    public int getMaxParallelSegmentDownloads() {
        return this._instanceDataManagerConfiguration.getProperty(MAX_PARALLEL_SEGMENT_DOWNLOADS, -1);
    }

    public String getSegmentDirectoryLoader() {
        return this._instanceDataManagerConfiguration.getProperty(SEGMENT_DIRECTORY_LOADER, "default");
    }

    public long getErrorCacheSize() {
        return this._instanceDataManagerConfiguration.getProperty(ERROR_CACHE_SIZE, 100L);
    }

    public boolean isStreamSegmentDownloadUntar() {
        return this._instanceDataManagerConfiguration.getProperty(ENABLE_STREAM_SEGMENT_DOWNLOAD_UNTAR, false);
    }

    public long getStreamSegmentDownloadUntarRateLimit() {
        return this._instanceDataManagerConfiguration.getProperty(STREAM_SEGMENT_DOWNLOAD_UNTAR_RATE_LIMIT, -1L);
    }

    public int getDeletedSegmentsCacheSize() {
        return this._instanceDataManagerConfiguration.getProperty(DELETED_SEGMENTS_CACHE_SIZE, 10000);
    }

    public int getDeletedSegmentsCacheTtlMinutes() {
        return this._instanceDataManagerConfiguration.getProperty(DELETED_SEGMENTS_CACHE_TTL_MINUTES, 2);
    }

    public String getSegmentPeerDownloadScheme() {
        return this._instanceDataManagerConfiguration.getProperty(PEER_DOWNLOAD_SCHEME);
    }

    public String toString() {
        Object configString = "";
        configString = (String)configString + "Instance Id: " + this.getInstanceId();
        configString = (String)configString + "\n\tInstance Data Dir: " + this.getInstanceDataDir();
        configString = (String)configString + "\n\tInstance Segment Tar Dir: " + this.getInstanceSegmentTarDir();
        configString = (String)configString + "\n\tBootstrap Segment Dir: " + this.getInstanceBootstrapSegmentDir();
        configString = (String)configString + "\n\tRead Mode: " + this.getReadMode();
        configString = (String)configString + "\n\tSegment format version: " + this.getSegmentFormatVersion();
        return configString;
    }
}

