/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.HelixManager;
import org.apache.helix.model.ExternalView;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.offline.TableDataManagerProvider;
import org.apache.pinot.core.data.manager.realtime.LLRealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.PinotFSSegmentUploader;
import org.apache.pinot.core.data.manager.realtime.SegmentBuildTimeLeaseExtender;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.core.util.SegmentRefreshSemaphore;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManagerConfig;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.utils.SegmentLocks;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderContext;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderRegistry;
import org.apache.pinot.server.starter.helix.HelixInstanceDataManagerConfig;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class HelixInstanceDataManager
implements InstanceDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelixInstanceDataManager.class);
    private static final long EXTERNAL_VIEW_DROPPED_MAX_WAIT_MS = 1200000L;
    private static final long EXTERNAL_VIEW_CHECK_INTERVAL_MS = 1000L;
    private final ConcurrentHashMap<String, TableDataManager> _tableDataManagerMap = new ConcurrentHashMap();
    private HelixInstanceDataManagerConfig _instanceDataManagerConfig;
    private String _instanceId;
    private HelixManager _helixManager;
    private ServerMetrics _serverMetrics;
    private ZkHelixPropertyStore<ZNRecord> _propertyStore;
    private SegmentUploader _segmentUploader;
    private LoadingCache<Pair<String, String>, SegmentErrorInfo> _errorCache;

    public synchronized void init(PinotConfiguration config, HelixManager helixManager, ServerMetrics serverMetrics) throws ConfigurationException {
        File instanceSegmentTarDir;
        LOGGER.info("Initializing Helix instance data manager");
        this._instanceDataManagerConfig = new HelixInstanceDataManagerConfig(config);
        LOGGER.info("HelixInstanceDataManagerConfig: {}", (Object)this._instanceDataManagerConfig);
        this._instanceId = this._instanceDataManagerConfig.getInstanceId();
        this._helixManager = helixManager;
        this._serverMetrics = serverMetrics;
        this._segmentUploader = new PinotFSSegmentUploader(this._instanceDataManagerConfig.getSegmentStoreUri(), 10000);
        File instanceDataDir = new File(this._instanceDataManagerConfig.getInstanceDataDir());
        if (!instanceDataDir.exists()) {
            Preconditions.checkState((boolean)instanceDataDir.mkdirs());
        }
        if (!(instanceSegmentTarDir = new File(this._instanceDataManagerConfig.getInstanceSegmentTarDir())).exists()) {
            Preconditions.checkState((boolean)instanceSegmentTarDir.mkdirs());
        }
        SegmentBuildTimeLeaseExtender.initExecutor();
        TableDataManagerProvider.init((InstanceDataManagerConfig)this._instanceDataManagerConfig);
        LOGGER.info("Initialized Helix instance data manager");
        this._errorCache = CacheBuilder.newBuilder().maximumSize(this._instanceDataManagerConfig.getErrorCacheSize()).build((CacheLoader)new CacheLoader<Pair<String, String>, SegmentErrorInfo>(){

            public SegmentErrorInfo load(Pair<String, String> tableNameWithTypeSegmentNamePair) {
                return null;
            }
        });
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public synchronized void start() {
        this._propertyStore = this._helixManager.getHelixPropertyStore();
        LOGGER.info("Helix instance data manager started");
    }

    public synchronized void shutDown() {
        for (TableDataManager tableDataManager : this._tableDataManagerMap.values()) {
            tableDataManager.shutDown();
        }
        SegmentBuildTimeLeaseExtender.shutdownExecutor();
        LOGGER.info("Helix instance data manager shut down");
    }

    public void addOfflineSegment(String offlineTableName, String segmentName, File indexDir) throws Exception {
        LOGGER.info("Adding segment: {} to table: {}", (Object)segmentName, (Object)offlineTableName);
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig(this._propertyStore, (String)offlineTableName);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: %s", (Object)offlineTableName);
        Schema schema = ZKMetadataProvider.getTableSchema(this._propertyStore, (TableConfig)tableConfig);
        this._tableDataManagerMap.computeIfAbsent(offlineTableName, k -> this.createTableDataManager((String)k, tableConfig)).addSegment(indexDir, new IndexLoadingConfig((InstanceDataManagerConfig)this._instanceDataManagerConfig, tableConfig, schema));
        LOGGER.info("Added segment: {} to table: {}", (Object)segmentName, (Object)offlineTableName);
    }

    public void addRealtimeSegment(String realtimeTableName, String segmentName) throws Exception {
        LOGGER.info("Adding segment: {} to table: {}", (Object)segmentName, (Object)realtimeTableName);
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig(this._propertyStore, (String)realtimeTableName);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: %s", (Object)realtimeTableName);
        Schema schema = ZKMetadataProvider.getTableSchema(this._propertyStore, (TableConfig)tableConfig);
        Preconditions.checkState((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for table: %s", (Object)realtimeTableName);
        SegmentZKMetadata zkMetadata = ZKMetadataProvider.getSegmentZKMetadata(this._propertyStore, (String)realtimeTableName, (String)segmentName);
        Preconditions.checkState((zkMetadata != null ? 1 : 0) != 0, (String)"Failed to find ZK metadata for segment: %s, table: %s", (Object)segmentName, (Object)realtimeTableName);
        HelixInstanceDataManager.setDefaultTimeValueIfInvalid(tableConfig, schema, zkMetadata);
        this._tableDataManagerMap.computeIfAbsent(realtimeTableName, k -> this.createTableDataManager((String)k, tableConfig)).addSegment(segmentName, new IndexLoadingConfig((InstanceDataManagerConfig)this._instanceDataManagerConfig, tableConfig, schema), zkMetadata);
        LOGGER.info("Added segment: {} to table: {}", (Object)segmentName, (Object)realtimeTableName);
    }

    @VisibleForTesting
    static void setDefaultTimeValueIfInvalid(TableConfig tableConfig, Schema schema, SegmentZKMetadata zkMetadata) {
        String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        if (StringUtils.isEmpty((CharSequence)timeColumnName)) {
            return;
        }
        DateTimeFieldSpec timeColumnSpec = schema.getSpecForTimeColumn(timeColumnName);
        Preconditions.checkState((timeColumnSpec != null ? 1 : 0) != 0, (String)"Failed to find time field: %s from schema: %s", (Object)timeColumnName, (Object)schema.getSchemaName());
        String defaultTimeString = timeColumnSpec.getDefaultNullValueString();
        DateTimeFormatSpec dateTimeFormatSpec = timeColumnSpec.getFormatSpec();
        try {
            long defaultTimeMs = dateTimeFormatSpec.fromFormatToMillis(defaultTimeString);
            if (TimeUtils.timeValueInValidRange((long)defaultTimeMs)) {
                return;
            }
        }
        catch (Exception defaultTimeMs) {
            // empty catch block
        }
        String creationTimeString = dateTimeFormatSpec.fromMillisToFormat(zkMetadata.getCreationTime());
        Object creationTime = timeColumnSpec.getDataType().convert(creationTimeString);
        timeColumnSpec.setDefaultNullValue(creationTime);
        LOGGER.info("Default time: {} does not comply with format: {}, using creation time: {} as the default time for table: {}", new Object[]{defaultTimeString, timeColumnSpec.getFormat(), creationTime, tableConfig.getTableName()});
    }

    private TableDataManager createTableDataManager(String tableNameWithType, TableConfig tableConfig) {
        LOGGER.info("Creating table data manager for table: {}", (Object)tableNameWithType);
        TableDataManagerConfig tableDataManagerConfig = new TableDataManagerConfig((InstanceDataManagerConfig)this._instanceDataManagerConfig, tableConfig);
        TableDataManager tableDataManager = TableDataManagerProvider.getTableDataManager((TableDataManagerConfig)tableDataManagerConfig, (String)this._instanceId, this._propertyStore, (ServerMetrics)this._serverMetrics, (HelixManager)this._helixManager, this._errorCache);
        tableDataManager.start();
        LOGGER.info("Created table data manager for table: {}", (Object)tableNameWithType);
        return tableDataManager;
    }

    public void deleteTable(String tableNameWithType) throws Exception {
        long endTimeMs = System.currentTimeMillis() + 1200000L;
        do {
            ExternalView externalView;
            if ((externalView = (ExternalView)this._helixManager.getHelixDataAccessor().getProperty(this._helixManager.getHelixDataAccessor().keyBuilder().externalView(tableNameWithType))) == null) {
                LOGGER.info("ExternalView converged for the table to delete: {}", (Object)tableNameWithType);
                this._tableDataManagerMap.compute(tableNameWithType, (k, v) -> {
                    if (v != null) {
                        v.shutDown();
                        LOGGER.info("Removed table: {}", (Object)tableNameWithType);
                    } else {
                        LOGGER.warn("Failed to find table data manager for table: {}, skip removing the table", (Object)tableNameWithType);
                    }
                    return null;
                });
                return;
            }
            Thread.sleep(1000L);
        } while (System.currentTimeMillis() < endTimeMs);
        throw new TimeoutException("Timeout while waiting for ExternalView to converge for the table to delete: " + tableNameWithType);
    }

    public void offloadSegment(String tableNameWithType, String segmentName) {
        LOGGER.info("Removing segment: {} from table: {}", (Object)segmentName, (Object)tableNameWithType);
        this._tableDataManagerMap.computeIfPresent(tableNameWithType, (k, v) -> {
            v.removeSegment(segmentName);
            LOGGER.info("Removed segment: {} from table: {}", (Object)segmentName, k);
            return v;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSegment(String tableNameWithType, String segmentName) throws Exception {
        Lock segmentLock = SegmentLocks.getSegmentLock((String)tableNameWithType, (String)segmentName);
        try {
            SegmentDirectoryLoader segmentLoader;
            segmentLock.lock();
            File segmentDir = this.getSegmentDataDirectory(tableNameWithType, segmentName);
            if (segmentDir.exists()) {
                FileUtils.deleteQuietly((File)segmentDir);
                LOGGER.info("Deleted segment directory {} on default tier", (Object)segmentDir);
            }
            if ((segmentLoader = SegmentDirectoryLoaderRegistry.getSegmentDirectoryLoader((String)this._instanceDataManagerConfig.getSegmentDirectoryLoader())) != null) {
                LOGGER.info("Deleting segment: {} further with segment loader: {}", (Object)segmentName, (Object)this._instanceDataManagerConfig.getSegmentDirectoryLoader());
                SegmentDirectoryLoaderContext ctx = new SegmentDirectoryLoaderContext.Builder().setSegmentName(segmentName).setTableDataDir(this._instanceDataManagerConfig.getInstanceDataDir() + "/" + tableNameWithType).build();
                segmentLoader.delete(ctx);
            }
        }
        finally {
            segmentLock.unlock();
        }
    }

    public void reloadSegment(String tableNameWithType, String segmentName, boolean forceDownload) throws Exception {
        LOGGER.info("Reloading single segment: {} in table: {}", (Object)segmentName, (Object)tableNameWithType);
        SegmentMetadata segmentMetadata = this.getSegmentMetadata(tableNameWithType, segmentName);
        if (segmentMetadata == null) {
            LOGGER.info("Segment metadata is null. Skip reloading segment: {} in table: {}", (Object)segmentName, (Object)tableNameWithType);
            return;
        }
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig(this._propertyStore, (String)tableNameWithType);
        Preconditions.checkNotNull((Object)tableConfig);
        Schema schema = ZKMetadataProvider.getTableSchema(this._propertyStore, (String)tableNameWithType);
        this.reloadSegmentWithMetadata(tableNameWithType, segmentMetadata, tableConfig, schema, forceDownload);
        LOGGER.info("Reloaded single segment: {} in table: {}", (Object)segmentName, (Object)tableNameWithType);
    }

    public void reloadAllSegments(String tableNameWithType, boolean forceDownload, SegmentRefreshSemaphore segmentRefreshSemaphore) throws Exception {
        LOGGER.info("Reloading all segments in table: {}", (Object)tableNameWithType);
        List<SegmentMetadata> segmentsMetadata = this.getAllSegmentsMetadata(tableNameWithType);
        this.reloadSegmentsWithMetadata(tableNameWithType, segmentsMetadata, forceDownload, segmentRefreshSemaphore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadSegments(String tableNameWithType, List<String> segmentNames, boolean forceDownload, SegmentRefreshSemaphore segmentRefreshSemaphore) throws Exception {
        LOGGER.info("Reloading multiple segments: {} in table: {}", segmentNames, (Object)tableNameWithType);
        TableDataManager tableDataManager = this._tableDataManagerMap.get(tableNameWithType);
        if (tableDataManager == null) {
            LOGGER.warn("Failed to find table data manager for table: {}, skipping reloading segments: {}", (Object)tableNameWithType, segmentNames);
            return;
        }
        ArrayList missingSegments = new ArrayList();
        List segmentDataManagers = tableDataManager.acquireSegments(segmentNames, missingSegments);
        if (!missingSegments.isEmpty()) {
            LOGGER.warn("Failed to get segment data manager for segments: {} of table: {}, skipping reloading them", missingSegments, (Object)tableDataManager);
        }
        ArrayList<SegmentMetadata> segmentsMetadata = new ArrayList<SegmentMetadata>(segmentDataManagers.size());
        try {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                segmentsMetadata.add(segmentDataManager.getSegment().getSegmentMetadata());
            }
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        this.reloadSegmentsWithMetadata(tableNameWithType, segmentsMetadata, forceDownload, segmentRefreshSemaphore);
    }

    private void reloadSegmentsWithMetadata(String tableNameWithType, List<SegmentMetadata> segmentsMetadata, boolean forceDownload, SegmentRefreshSemaphore segmentRefreshSemaphore) throws Exception {
        long startTime = System.currentTimeMillis();
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig(this._propertyStore, (String)tableNameWithType);
        Preconditions.checkNotNull((Object)tableConfig);
        Schema schema = ZKMetadataProvider.getTableSchema(this._propertyStore, (String)tableNameWithType);
        ArrayList failedSegments = new ArrayList();
        ExecutorService workers = Executors.newCachedThreadPool();
        AtomicReference sampleException = new AtomicReference();
        CompletableFuture.allOf((CompletableFuture[])segmentsMetadata.stream().map(segmentMetadata -> CompletableFuture.runAsync(() -> {
            String segmentName = segmentMetadata.getName();
            try {
                segmentRefreshSemaphore.acquireSema(segmentMetadata.getName(), LOGGER);
                try {
                    this.reloadSegmentWithMetadata(tableNameWithType, (SegmentMetadata)segmentMetadata, tableConfig, schema, forceDownload);
                }
                finally {
                    segmentRefreshSemaphore.releaseSema();
                }
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while reloading segment: {} in table: {}", new Object[]{segmentName, tableNameWithType, e});
                failedSegments.add(segmentName);
                sampleException.set(e);
            }
        }, workers)).toArray(CompletableFuture[]::new)).get();
        workers.shutdownNow();
        if (sampleException.get() != null) {
            throw new RuntimeException(String.format("Failed to reload %d/%d segments: %s in table: %s", failedSegments.size(), segmentsMetadata.size(), failedSegments, tableNameWithType), (Throwable)sampleException.get());
        }
        LOGGER.info("Reloaded segments with metadata in table: {}. Duration: {}", (Object)tableNameWithType, (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadSegmentWithMetadata(String tableNameWithType, SegmentMetadata segmentMetadata, TableConfig tableConfig, @Nullable Schema schema, boolean forceDownload) throws Exception {
        String segmentName = segmentMetadata.getName();
        LOGGER.info("Reloading segment: {} in table: {} with forceDownload: {}", new Object[]{segmentName, tableNameWithType, forceDownload});
        TableDataManager tableDataManager = this._tableDataManagerMap.get(tableNameWithType);
        if (tableDataManager == null) {
            LOGGER.warn("Failed to find table data manager for table: {}, skipping reloading segment", (Object)tableNameWithType);
            return;
        }
        if (segmentMetadata.isMutableSegment()) {
            SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segmentName);
            if (segmentDataManager == null) {
                LOGGER.warn("Failed to find segment data manager for table: {}, segment: {}, skipping reloading segment", (Object)tableNameWithType, (Object)segmentName);
                return;
            }
            try {
                if (!this._instanceDataManagerConfig.shouldReloadConsumingSegment()) {
                    LOGGER.warn("Skip reloading consuming segment: {} in table: {} as configured", (Object)segmentName, (Object)tableNameWithType);
                    return;
                }
                if (!(segmentDataManager instanceof LLRealtimeSegmentDataManager)) {
                    LOGGER.warn("Cannot reload non-LLC consuming segment: {} in table: {}", (Object)segmentName, (Object)tableNameWithType);
                    return;
                }
                LOGGER.info("Reloading (force committing) LLC consuming segment: {} in table: {}", (Object)segmentName, (Object)tableNameWithType);
                ((LLRealtimeSegmentDataManager)segmentDataManager).forceCommit();
                return;
            }
            finally {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        SegmentZKMetadata zkMetadata = ZKMetadataProvider.getSegmentZKMetadata(this._propertyStore, (String)tableNameWithType, (String)segmentName);
        Preconditions.checkNotNull((Object)zkMetadata);
        Lock segmentLock = SegmentLocks.getSegmentLock((String)tableNameWithType, (String)segmentName);
        try {
            segmentLock.lock();
            tableDataManager.reloadSegment(segmentName, new IndexLoadingConfig((InstanceDataManagerConfig)this._instanceDataManagerConfig, tableConfig, schema), zkMetadata, segmentMetadata, schema, forceDownload);
            LOGGER.info("Reloaded segment: {} of table: {}", (Object)segmentName, (Object)tableNameWithType);
        }
        finally {
            segmentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrReplaceSegment(String tableNameWithType, String segmentName) throws Exception {
        LOGGER.info("Adding or replacing segment: {} for table: {}", (Object)segmentName, (Object)tableNameWithType);
        TableConfig tableConfig = ZKMetadataProvider.getTableConfig(this._propertyStore, (String)tableNameWithType);
        Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: %s", (Object)tableNameWithType);
        Schema schema = ZKMetadataProvider.getTableSchema(this._propertyStore, (TableConfig)tableConfig);
        SegmentZKMetadata zkMetadata = ZKMetadataProvider.getSegmentZKMetadata(this._propertyStore, (String)tableNameWithType, (String)segmentName);
        Preconditions.checkState((zkMetadata != null ? 1 : 0) != 0, (String)"Failed to find ZK metadata for segment: %s, table: %s", (Object)segmentName, (Object)tableNameWithType);
        if (schema != null) {
            HelixInstanceDataManager.setDefaultTimeValueIfInvalid(tableConfig, schema, zkMetadata);
        }
        Lock segmentLock = SegmentLocks.getSegmentLock((String)tableNameWithType, (String)segmentName);
        try {
            segmentLock.lock();
            SegmentMetadata localMetadata = this.getSegmentMetadata(tableNameWithType, segmentName);
            this._tableDataManagerMap.computeIfAbsent(tableNameWithType, k -> this.createTableDataManager((String)k, tableConfig)).addOrReplaceSegment(segmentName, new IndexLoadingConfig((InstanceDataManagerConfig)this._instanceDataManagerConfig, tableConfig, schema), zkMetadata, localMetadata);
            LOGGER.info("Added or replaced segment: {} of table: {}", (Object)segmentName, (Object)tableNameWithType);
        }
        finally {
            segmentLock.unlock();
        }
    }

    public Set<String> getAllTables() {
        return this._tableDataManagerMap.keySet();
    }

    @Nullable
    public TableDataManager getTableDataManager(String tableNameWithType) {
        return this._tableDataManagerMap.get(tableNameWithType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SegmentMetadata getSegmentMetadata(String tableNameWithType, String segmentName) {
        TableDataManager tableDataManager = this._tableDataManagerMap.get(tableNameWithType);
        if (tableDataManager != null) {
            SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segmentName);
            if (segmentDataManager == null) {
                return null;
            }
            try {
                SegmentMetadata segmentMetadata = segmentDataManager.getSegment().getSegmentMetadata();
                return segmentMetadata;
            }
            finally {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SegmentMetadata> getAllSegmentsMetadata(String tableNameWithType) {
        TableDataManager tableDataManager = this._tableDataManagerMap.get(tableNameWithType);
        if (tableDataManager == null) {
            return Collections.emptyList();
        }
        List segmentDataManagers = tableDataManager.acquireAllSegments();
        try {
            ArrayList<SegmentMetadata> segmentsMetadata = new ArrayList<SegmentMetadata>(segmentDataManagers.size());
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                segmentsMetadata.add(segmentDataManager.getSegment().getSegmentMetadata());
            }
            ArrayList<SegmentMetadata> arrayList = segmentsMetadata;
            return arrayList;
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
    }

    public File getSegmentDataDirectory(String tableNameWithType, String segmentName) {
        return new File(new File(this._instanceDataManagerConfig.getInstanceDataDir(), tableNameWithType), segmentName);
    }

    public String getSegmentFileDirectory() {
        return this._instanceDataManagerConfig.getInstanceSegmentTarDir();
    }

    public int getMaxParallelRefreshThreads() {
        return this._instanceDataManagerConfig.getMaxParallelRefreshThreads();
    }

    public ZkHelixPropertyStore<ZNRecord> getPropertyStore() {
        return this._propertyStore;
    }

    public SegmentUploader getSegmentUploader() {
        return this._segmentUploader;
    }

    public void forceCommit(String tableNameWithType, Set<String> segmentNames) {
        Preconditions.checkArgument((boolean)TableNameBuilder.isRealtimeTableResource((String)tableNameWithType), (Object)String.format("Force commit is only supported for segments of realtime tables - table name: %s segment names: %s", tableNameWithType, segmentNames));
        TableDataManager tableDataManager = this._tableDataManagerMap.get(tableNameWithType);
        if (tableDataManager != null) {
            segmentNames.forEach(segName -> {
                SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segName);
                if (segmentDataManager != null) {
                    try {
                        if (segmentDataManager instanceof LLRealtimeSegmentDataManager) {
                            LLRealtimeSegmentDataManager llSegmentDataManager = (LLRealtimeSegmentDataManager)segmentDataManager;
                            llSegmentDataManager.forceCommit();
                        }
                    }
                    finally {
                        tableDataManager.releaseSegment(segmentDataManager);
                    }
                }
            });
        }
    }
}

