/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter.helix;

import org.apache.pinot.server.conf.ServerConf;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.CommonConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHelixStarterServerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHelixStarterServerConfig.class);

    private DefaultHelixStarterServerConfig() {
    }

    public static ServerConf getDefaultHelixServerConfig(PinotConfiguration externalConfigs) {
        PinotConfiguration defaultConfigs = DefaultHelixStarterServerConfig.loadDefaultServerConf();
        for (String key : externalConfigs.getKeys()) {
            defaultConfigs.setProperty(key, externalConfigs.getRawProperty(key));
            LOGGER.info("External config key: {}, value: {}", (Object)key, (Object)externalConfigs.getProperty(key));
        }
        return new ServerConf(defaultConfigs);
    }

    public static PinotConfiguration loadDefaultServerConf() {
        PinotConfiguration serverConf = new PinotConfiguration();
        serverConf.addProperty("pinot.server.instance.dataDir", (Object)CommonConstants.Server.DEFAULT_INSTANCE_DATA_DIR);
        serverConf.addProperty("pinot.server.instance.segmentTarDir", (Object)CommonConstants.Server.DEFAULT_INSTANCE_SEGMENT_TAR_DIR);
        serverConf.addProperty("pinot.server.instance.readMode", (Object)"mmap");
        serverConf.addProperty("pinot.server.instance.data.manager.class", (Object)"org.apache.pinot.server.starter.helix.HelixInstanceDataManager");
        serverConf.addProperty("pinot.server.query.executor.class", (Object)"org.apache.pinot.core.query.executor.ServerQueryExecutorV1Impl");
        serverConf.addProperty("pinot.server.query.executor.pruner.class", (Object)"ColumnValueSegmentPruner,SelectionQuerySegmentPruner");
        serverConf.addProperty("pinot.server.requestHandlerFactory.class", (Object)"org.apache.pinot.server.request.SimpleRequestHandlerFactory");
        serverConf.addProperty("pinot.server.netty.port", (Object)8098);
        return serverConf;
    }
}

