/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.helix.HelixManager;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQueriesDisabledTracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerQueriesDisabledTracker.class);
    private static final long FETCH_INTERVAL_MINS = 10L;
    private final ScheduledExecutorService _executorService = Executors.newSingleThreadScheduledExecutor();
    private final HelixManager _helixManager;
    private final ServerMetrics _serverMetrics;
    private final String _clusterName;
    private final String _instanceId;
    private AtomicBoolean _queriesDisabled = new AtomicBoolean();

    public ServerQueriesDisabledTracker(String helixClusterName, String instanceId, HelixManager helixManager, ServerMetrics serverMetrics) {
        this._helixManager = helixManager;
        this._serverMetrics = serverMetrics;
        this._clusterName = helixClusterName;
        this._instanceId = instanceId;
    }

    public void start() {
        this._serverMetrics.addCallbackGauge("queriesDisabled", () -> this._queriesDisabled.get() ? 1L : 0L);
        LOGGER.info("Tracking server queries disabled.");
        this._executorService.scheduleWithFixedDelay(() -> {
            ZNRecord instanceConfigZNRecord = this._helixManager.getConfigAccessor().getInstanceConfig(this._clusterName, this._instanceId).getRecord();
            if (instanceConfigZNRecord == null) {
                LOGGER.error("Failed to get instance config: {} in {} from zookeeper", (Object)this._instanceId, (Object)this._clusterName);
            } else {
                this._queriesDisabled.set(instanceConfigZNRecord.getBooleanField("queriesDisabled", false));
            }
        }, 0L, 10L, TimeUnit.MINUTES);
    }

    public void stop() {
        LOGGER.info("Stopped tracking server queries disabled.");
        this._executorService.shutdown();
    }
}

