/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.starter;

import com.google.common.base.Preconditions;
import io.netty.channel.ChannelHandler;
import java.util.HashSet;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.config.GrpcConfig;
import org.apache.pinot.common.config.NettyConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.TlsUtils;
import org.apache.pinot.common.version.PinotVersion;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.core.query.executor.QueryExecutor;
import org.apache.pinot.core.query.scheduler.QueryScheduler;
import org.apache.pinot.core.query.scheduler.QuerySchedulerFactory;
import org.apache.pinot.core.transport.ChannelHandlerFactory;
import org.apache.pinot.core.transport.InstanceRequestHandler;
import org.apache.pinot.core.transport.QueryServer;
import org.apache.pinot.core.transport.grpc.GrpcQueryServer;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.server.access.AccessControlFactory;
import org.apache.pinot.server.access.AllowAllAccessFactory;
import org.apache.pinot.server.conf.ServerConf;
import org.apache.pinot.server.worker.WorkerQueryServer;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.metrics.PinotMetricUtils;
import org.apache.pinot.spi.metrics.PinotMetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInstance {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerInstance.class);
    private final ServerMetrics _serverMetrics;
    private final InstanceDataManager _instanceDataManager;
    private final QueryExecutor _queryExecutor;
    private final LongAccumulator _latestQueryTime;
    private final QueryScheduler _queryScheduler;
    private final QueryServer _nettyQueryServer;
    private final QueryServer _nettyTlsQueryServer;
    private final GrpcQueryServer _grpcQueryServer;
    private final AccessControl _accessControl;
    private final HelixManager _helixManager;
    private final WorkerQueryServer _workerQueryServer;
    private ChannelHandler _instanceRequestHandler;
    private boolean _dataManagerStarted = false;
    private boolean _queryServerStarted = false;

    public ServerInstance(ServerConf serverConf, HelixManager helixManager, AccessControlFactory accessControlFactory) throws Exception {
        LOGGER.info("Initializing server instance");
        this._helixManager = helixManager;
        LOGGER.info("Initializing server metrics");
        PinotMetricsRegistry metricsRegistry = PinotMetricUtils.getPinotMetricsRegistry((PinotConfiguration)serverConf.getMetricsConfig());
        this._serverMetrics = new ServerMetrics(serverConf.getMetricsPrefix(), metricsRegistry, serverConf.emitTableLevelMetrics(), serverConf.getAllowedTablesForEmittingMetrics());
        this._serverMetrics.initializeGlobalMeters();
        this._serverMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)ServerGauge.VERSION, PinotVersion.VERSION_METRIC_NAME, 1L);
        ServerMetrics.register((ServerMetrics)this._serverMetrics);
        String instanceDataManagerClassName = serverConf.getInstanceDataManagerClassName();
        LOGGER.info("Initializing instance data manager of class: {}", (Object)instanceDataManagerClassName);
        this._instanceDataManager = (InstanceDataManager)Class.forName(instanceDataManagerClassName).newInstance();
        this._instanceDataManager.init(serverConf.getInstanceDataManagerConfig(), helixManager, this._serverMetrics);
        FunctionRegistry.init();
        String queryExecutorClassName = serverConf.getQueryExecutorClassName();
        LOGGER.info("Initializing query executor of class: {}", (Object)queryExecutorClassName);
        this._queryExecutor = (QueryExecutor)Class.forName(queryExecutorClassName).newInstance();
        PinotConfiguration queryExecutorConfig = serverConf.getQueryExecutorConfig();
        this._queryExecutor.init(queryExecutorConfig, this._instanceDataManager, this._serverMetrics);
        LOGGER.info("Initializing query scheduler");
        this._latestQueryTime = new LongAccumulator(Long::max, 0L);
        this._queryScheduler = QuerySchedulerFactory.create((PinotConfiguration)serverConf.getSchedulerConfig(), (QueryExecutor)this._queryExecutor, (ServerMetrics)this._serverMetrics, (LongAccumulator)this._latestQueryTime);
        TlsConfig tlsConfig = TlsUtils.extractTlsConfig((PinotConfiguration)serverConf.getPinotConfig(), (String)"pinot.server.tls");
        NettyConfig nettyConfig = NettyConfig.extractNettyConfig((PinotConfiguration)serverConf.getPinotConfig(), (String)"pinot.server.netty");
        accessControlFactory.init(serverConf.getPinotConfig().subset("pinot.server.admin.access.control"), helixManager);
        this._accessControl = accessControlFactory.create();
        if (serverConf.isMultiStageServerEnabled()) {
            LOGGER.info("Initializing Multi-stage query engine");
            this._workerQueryServer = new WorkerQueryServer(serverConf.getPinotConfig(), this._instanceDataManager, helixManager, this._serverMetrics);
        } else {
            this._workerQueryServer = null;
        }
        if (serverConf.isNettyServerEnabled()) {
            int nettyPort = serverConf.getNettyPort();
            LOGGER.info("Initializing Netty query server on port: {}", (Object)nettyPort);
            this._instanceRequestHandler = ChannelHandlerFactory.getInstanceRequestHandler((String)helixManager.getInstanceName(), (PinotConfiguration)serverConf.getPinotConfig(), (QueryScheduler)this._queryScheduler, (ServerMetrics)this._serverMetrics, (AccessControl)new AllowAllAccessFactory().create());
            this._nettyQueryServer = new QueryServer(nettyPort, nettyConfig, this._instanceRequestHandler);
        } else {
            this._nettyQueryServer = null;
        }
        if (serverConf.isNettyTlsServerEnabled()) {
            int nettySecPort = serverConf.getNettyTlsPort();
            LOGGER.info("Initializing TLS-secured Netty query server on port: {}", (Object)nettySecPort);
            this._instanceRequestHandler = ChannelHandlerFactory.getInstanceRequestHandler((String)helixManager.getInstanceName(), (PinotConfiguration)serverConf.getPinotConfig(), (QueryScheduler)this._queryScheduler, (ServerMetrics)this._serverMetrics, (AccessControl)this._accessControl);
            this._nettyTlsQueryServer = new QueryServer(nettySecPort, nettyConfig, tlsConfig, this._instanceRequestHandler);
        } else {
            this._nettyTlsQueryServer = null;
        }
        if (serverConf.isEnableGrpcServer()) {
            int grpcPort = serverConf.getGrpcPort();
            LOGGER.info("Initializing gRPC query server on port: {}", (Object)grpcPort);
            this._grpcQueryServer = new GrpcQueryServer(grpcPort, GrpcConfig.buildGrpcQueryConfig((PinotConfiguration)serverConf.getPinotConfig()), serverConf.isGrpcTlsServerEnabled() ? TlsUtils.extractTlsConfig((PinotConfiguration)serverConf.getPinotConfig(), (String)"pinot.server.grpctls") : null, this._queryExecutor, this._serverMetrics, this._accessControl);
        } else {
            this._grpcQueryServer = null;
        }
        LOGGER.info("Initializing transform functions");
        HashSet transformFunctionClasses = new HashSet();
        for (String transformFunctionClassName : serverConf.getTransformFunctions()) {
            try {
                transformFunctionClasses.add(Class.forName(transformFunctionClassName));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Failed to find transform function class: " + transformFunctionClassName);
            }
        }
        TransformFunctionFactory.init(transformFunctionClasses);
        LOGGER.info("Finish initializing server instance");
    }

    public synchronized void startDataManager() {
        if (this._dataManagerStarted) {
            LOGGER.info("Data manager is already running, skipping the start");
            return;
        }
        LOGGER.info("Starting data manager");
        this._instanceDataManager.start();
        this._dataManagerStarted = true;
        LOGGER.info("Finish starting data manager");
    }

    public synchronized void startQueryServer() {
        if (this._queryServerStarted) {
            LOGGER.warn("Query server is already running, skipping the start");
            return;
        }
        LOGGER.info("Starting query server");
        LOGGER.info("Starting query executor");
        this._queryExecutor.start();
        LOGGER.info("Starting query scheduler");
        this._queryScheduler.start();
        if (this._nettyQueryServer != null) {
            LOGGER.info("Starting Netty query server");
            this._nettyQueryServer.start();
        }
        if (this._nettyTlsQueryServer != null) {
            LOGGER.info("Starting TLS-secured Netty query server");
            this._nettyTlsQueryServer.start();
        }
        if (this._grpcQueryServer != null) {
            LOGGER.info("Starting gRPC query server");
            this._grpcQueryServer.start();
        }
        if (this._workerQueryServer != null) {
            LOGGER.info("Starting worker query server");
            this._workerQueryServer.start();
        }
        this._queryServerStarted = true;
        LOGGER.info("Finish starting query server");
    }

    public synchronized void shutDown() {
        if (!this._dataManagerStarted) {
            LOGGER.warn("Server instance is not running, skipping the shut down");
            return;
        }
        LOGGER.info("Shutting down server instance");
        if (this._queryServerStarted) {
            LOGGER.info("Shutting down query server");
            if (this._nettyQueryServer != null) {
                LOGGER.info("Shutting down Netty query server");
                this._nettyQueryServer.shutDown();
            }
            if (this._nettyTlsQueryServer != null) {
                LOGGER.info("Shutting down TLS-secured Netty query server");
                this._nettyTlsQueryServer.shutDown();
            }
            if (this._grpcQueryServer != null) {
                LOGGER.info("Shutting down gRPC query server");
                this._grpcQueryServer.shutdown();
            }
            if (this._workerQueryServer != null) {
                LOGGER.info("Shutting down worker query server");
                this._workerQueryServer.shutDown();
            }
            LOGGER.info("Shutting down query scheduler");
            this._queryScheduler.stop();
            LOGGER.info("Shutting down query executor");
            this._queryExecutor.shutDown();
            this._queryServerStarted = false;
            LOGGER.info("Finish shutting down query server");
        }
        LOGGER.info("Shutting down data manager");
        this._instanceDataManager.shutDown();
        LOGGER.info("Shutting down metrics registry");
        this._serverMetrics.getMetricsRegistry().shutdown();
        this._dataManagerStarted = false;
        LOGGER.info("Finish shutting down server instance");
    }

    public ServerMetrics getServerMetrics() {
        return this._serverMetrics;
    }

    public InstanceDataManager getInstanceDataManager() {
        return this._instanceDataManager;
    }

    public long getLatestQueryTime() {
        return this._latestQueryTime.get();
    }

    public InstanceRequestHandler getInstanceRequestHandler() {
        Preconditions.checkState((boolean)(this._instanceRequestHandler instanceof InstanceRequestHandler), (Object)"Unexpected type of instance request handler");
        return (InstanceRequestHandler)this._instanceRequestHandler;
    }

    public HelixManager getHelixManager() {
        return this._helixManager;
    }
}

