/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FileUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.restlet.resources.ResourceUtils;
import org.apache.pinot.common.restlet.resources.SegmentConsumerInfo;
import org.apache.pinot.common.restlet.resources.TableMetadataInfo;
import org.apache.pinot.common.restlet.resources.TableSegmentValidationInfo;
import org.apache.pinot.common.restlet.resources.TableSegments;
import org.apache.pinot.common.restlet.resources.TablesList;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.SegmentUploader;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.server.access.AccessControlFactory;
import org.apache.pinot.server.access.HttpRequesterIdentity;
import org.apache.pinot.server.access.RequesterIdentity;
import org.apache.pinot.server.api.resources.ErrorInfo;
import org.apache.pinot.server.api.resources.SegmentMetadataFetcher;
import org.apache.pinot.server.api.resources.ServerResourceUtils;
import org.apache.pinot.server.starter.ServerInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.stream.ConsumerPartitionState;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class TablesResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(TablesResource.class);
    private static final String PEER_SEGMENT_DOWNLOAD_DIR = "peerSegmentDownloadDir";
    private static final String SEGMENT_UPLOAD_DIR = "segmentUploadDir";
    @Inject
    private ServerInstance _serverInstance;
    @Inject
    private AccessControlFactory _accessControlFactory;
    @Inject
    @Named(value="serverInstanceId")
    private String _instanceId;

    @GET
    @Path(value="/tables")
    @Produces(value={"application/json"})
    @ApiOperation(value="List tables", notes="List all the tables on this server")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=TablesList.class), @ApiResponse(code=500, message="Server initialization error", response=ErrorInfo.class)})
    public String listTables() {
        InstanceDataManager instanceDataManager = ServerResourceUtils.checkGetInstanceDataManager(this._serverInstance);
        ArrayList tables = new ArrayList(instanceDataManager.getAllTables());
        return ResourceUtils.convertToJsonString((Object)new TablesList(tables));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/tables/{tableName}/segments")
    @Produces(value={"application/json"})
    @ApiOperation(value="List table segments", notes="List segments of table hosted on this server")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=TableSegments.class), @ApiResponse(code=500, message="Server initialization error", response=ErrorInfo.class)})
    public String listTableSegments(@ApiParam(value="Table name including type", required=true, example="myTable_OFFLINE") @PathParam(value="tableName") String tableName) {
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableName);
        List segmentDataManagers = tableDataManager.acquireAllSegments();
        try {
            ArrayList<String> segments = new ArrayList<String>(segmentDataManagers.size());
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                segments.add(segmentDataManager.getSegmentName());
            }
            String string = ResourceUtils.convertToJsonString((Object)new TableSegments(segments));
            return string;
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @GET
    @Encoded
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/metadata")
    @ApiOperation(value="List metadata for all segments of a given table", notes="List segments metadata of table hosted on this server")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Table not found")})
    public String getSegmentMetadata(@ApiParam(value="Table Name with type", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Column name", allowMultiple=true) @QueryParam(value="columns") @DefaultValue(value="") List<String> columns) throws WebApplicationException {
        InstanceDataManager instanceDataManager = this._serverInstance.getInstanceDataManager();
        if (instanceDataManager == null) {
            throw new WebApplicationException("Invalid server initialization", Response.Status.INTERNAL_SERVER_ERROR);
        }
        TableDataManager tableDataManager = instanceDataManager.getTableDataManager(tableName);
        if (tableDataManager == null) {
            throw new WebApplicationException("Table: " + tableName + " is not found", Response.Status.NOT_FOUND);
        }
        ArrayList<String> decodedColumns = new ArrayList<String>(columns.size());
        for (String string : columns) {
            try {
                decodedColumns.add(URLDecoder.decode(string, StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        boolean allColumns = false;
        for (String column : decodedColumns) {
            if (!column.equals("*")) continue;
            allColumns = true;
            break;
        }
        HashSet hashSet = allColumns ? null : new HashSet(decodedColumns);
        List segmentDataManagers = tableDataManager.acquireAllSegments();
        long totalSegmentSizeBytes = 0L;
        long totalNumRows = 0L;
        HashMap<String, Double> columnLengthMap = new HashMap<String, Double>();
        HashMap<String, Double> columnCardinalityMap = new HashMap<String, Double>();
        HashMap<String, Double> maxNumMultiValuesMap = new HashMap<String, Double>();
        HashMap<String, Map> columnIndexSizesMap = new HashMap<String, Map>();
        try {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                void var7_11;
                if (!(segmentDataManager instanceof ImmutableSegmentDataManager)) continue;
                ImmutableSegment immutableSegment = (ImmutableSegment)segmentDataManager.getSegment();
                long segmentSizeBytes = immutableSegment.getSegmentSizeBytes();
                SegmentMetadataImpl segmentMetadata = (SegmentMetadataImpl)segmentDataManager.getSegment().getSegmentMetadata();
                totalSegmentSizeBytes += segmentSizeBytes;
                totalNumRows += (long)segmentMetadata.getTotalDocs();
                if (var7_11 == null) {
                    Set set = segmentMetadata.getAllColumns();
                } else {
                    var7_11.retainAll(segmentMetadata.getAllColumns());
                }
                for (String column : var7_11) {
                    ColumnMetadata columnMetadata = (ColumnMetadata)segmentMetadata.getColumnMetadataMap().get(column);
                    int columnLength = 0;
                    FieldSpec.DataType storedDataType = columnMetadata.getDataType().getStoredType();
                    if (storedDataType.isFixedWidth()) {
                        columnLength = storedDataType.size();
                    } else if (columnMetadata.hasDictionary()) {
                        columnLength = columnMetadata.getColumnMaxLength();
                    } else if (storedDataType == FieldSpec.DataType.STRING || storedDataType == FieldSpec.DataType.BYTES) {
                        if (columnMetadata.getMaxValue() != null) {
                            String maxValueString = (String)((Object)columnMetadata.getMaxValue());
                            columnLength = maxValueString.getBytes(StandardCharsets.UTF_8).length;
                        }
                    } else {
                        columnLength = 512;
                    }
                    int columnCardinality = columnMetadata.getCardinality();
                    columnLengthMap.merge(column, Double.valueOf(columnLength), Double::sum);
                    columnCardinalityMap.merge(column, Double.valueOf(columnCardinality), Double::sum);
                    if (!columnMetadata.isSingleValue()) {
                        int maxNumMultiValues = columnMetadata.getMaxNumberOfMultiValues();
                        maxNumMultiValuesMap.merge(column, Double.valueOf(maxNumMultiValues), Double::sum);
                    }
                    for (Map.Entry entry : columnMetadata.getIndexSizeMap().entrySet()) {
                        String indexName = ((ColumnIndexType)entry.getKey()).getIndexName();
                        Map columnIndexSizes = columnIndexSizesMap.getOrDefault(column, new HashMap());
                        Double indexSize = columnIndexSizes.getOrDefault(indexName, 0.0) + (double)((Long)entry.getValue()).longValue();
                        columnIndexSizes.put(indexName, indexSize);
                        columnIndexSizesMap.put(column, columnIndexSizes);
                    }
                }
            }
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        TableMetadataInfo tableMetadataInfo = new TableMetadataInfo(tableDataManager.getTableName(), totalSegmentSizeBytes, (long)segmentDataManagers.size(), totalNumRows, columnLengthMap, columnCardinalityMap, maxNumMultiValuesMap, columnIndexSizesMap);
        return ResourceUtils.convertToJsonString((Object)tableMetadataInfo);
    }

    @GET
    @Encoded
    @Path(value="/tables/{tableName}/segments/{segmentName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Provide segment metadata", notes="Provide segments metadata for the segment on server")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error", response=ErrorInfo.class), @ApiResponse(code=404, message="Table or segment not found", response=ErrorInfo.class)})
    public String getSegmentMetadata(@ApiParam(value="Table name including type", required=true, example="myTable_OFFLINE") @PathParam(value="tableName") String tableName, @ApiParam(value="Segment name", required=true) @PathParam(value="segmentName") String segmentName, @ApiParam(value="Column name", allowMultiple=true) @QueryParam(value="columns") @DefaultValue(value="") List<String> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            try {
                columns.set(i, URLDecoder.decode(columns.get(i), StandardCharsets.UTF_8.name()));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getCause());
            }
        }
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableName);
        try {
            segmentName = URLDecoder.decode(segmentName, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getCause());
        }
        SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segmentName);
        if (segmentDataManager == null) {
            throw new WebApplicationException(String.format("Table %s segments %s does not exist", tableName, segmentName), Response.Status.NOT_FOUND);
        }
        try {
            String string = SegmentMetadataFetcher.getSegmentMetadata(segmentDataManager, columns);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Failed to convert table {} segment {} to json", (Object)tableName, (Object)segmentName);
            throw new WebApplicationException("Failed to convert segment metadata to json", Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            tableDataManager.releaseSegment(segmentDataManager);
        }
    }

    @GET
    @Path(value="/tables/{tableName}/segments/crc")
    @Produces(value={"application/json"})
    @ApiOperation(value="Provide segment crc information", notes="Provide crc information for the segments on server")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error", response=ErrorInfo.class), @ApiResponse(code=404, message="Table or segment not found", response=ErrorInfo.class)})
    public String getCrcMetadataForTable(@ApiParam(value="Table name including type", required=true, example="myTable_OFFLINE") @PathParam(value="tableName") String tableName) {
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableName);
        List segmentDataManagers = tableDataManager.acquireAllSegments();
        try {
            HashMap<String, String> segmentCrcForTable = new HashMap<String, String>();
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                segmentCrcForTable.put(segmentDataManager.getSegmentName(), segmentDataManager.getSegment().getSegmentMetadata().getCrc());
            }
            String string = ResourceUtils.convertToJsonString(segmentCrcForTable);
            return string;
        }
        catch (Exception e) {
            throw new WebApplicationException("Failed to convert crc information to json", Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/octet-stream"})
    @Path(value="/segments/{tableNameWithType}/{segmentName}")
    @ApiOperation(value="Download an immutable segment", notes="Download an immutable segment in zipped tar format.")
    public Response downloadSegment(@ApiParam(value="Name of the table with type REALTIME OR OFFLINE", required=true, example="myTable_OFFLINE") @PathParam(value="tableNameWithType") String tableNameWithType, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") @Encoded String segmentName, @Context HttpHeaders httpHeaders) throws Exception {
        boolean hasDataAccess;
        LOGGER.info("Received a request to download segment {} for table {}", (Object)segmentName, (Object)tableNameWithType);
        try {
            AccessControl accessControl = this._accessControlFactory.create();
            HttpRequesterIdentity httpRequestIdentity = new HttpRequesterIdentity(httpHeaders);
            hasDataAccess = accessControl.hasDataAccess((RequesterIdentity)httpRequestIdentity, tableNameWithType);
        }
        catch (Exception e) {
            throw new WebApplicationException("Caught exception while validating access to table: " + tableNameWithType, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (!hasDataAccess) {
            throw new WebApplicationException("No data access to table: " + tableNameWithType, Response.Status.FORBIDDEN);
        }
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableNameWithType);
        SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segmentName);
        if (segmentDataManager == null) {
            throw new WebApplicationException(String.format("Table %s segment %s does not exist", tableNameWithType, segmentName), Response.Status.NOT_FOUND);
        }
        try {
            File tmpSegmentTarDir = new File(this._serverInstance.getInstanceDataManager().getSegmentFileDirectory(), PEER_SEGMENT_DOWNLOAD_DIR);
            tmpSegmentTarDir.mkdir();
            File segmentTarFile = new File(tmpSegmentTarDir, tableNameWithType + "_" + segmentName + "_" + UUID.randomUUID() + ".tar.gz");
            TarGzCompressionUtils.createTarGzFile((File)new File(tableDataManager.getTableDataDir(), segmentName), (File)segmentTarFile);
            Response.ResponseBuilder builder = Response.ok();
            builder.entity(output -> {
                try {
                    Files.copy(segmentTarFile.toPath(), output);
                }
                finally {
                    FileUtils.deleteQuietly((File)segmentTarFile);
                }
            });
            builder.header("Content-Disposition", (Object)("attachment; filename=" + segmentTarFile.getName()));
            builder.header("Content-Length", (Object)segmentTarFile.length());
            Response response = builder.build();
            return response;
        }
        finally {
            tableDataManager.releaseSegment(segmentDataManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/segments/{realtimeTableName}/{segmentName}/upload")
    @Produces(value={"application/json"})
    @ApiOperation(value="Upload a low level consumer segment to segment store and return the segment download url", notes="Upload a low level consumer segment to segment store and return the segment download url")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error", response=ErrorInfo.class), @ApiResponse(code=404, message="Table or segment not found", response=ErrorInfo.class), @ApiResponse(code=400, message="Bad request", response=ErrorInfo.class)})
    public String uploadLLCSegment(@ApiParam(value="Name of the REALTIME table", required=true) @PathParam(value="realtimeTableName") String realtimeTableName, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") String segmentName) throws Exception {
        String string;
        LOGGER.info("Received a request to upload low level consumer segment {} for table {}", (Object)segmentName, (Object)realtimeTableName);
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)realtimeTableName);
        if (TableType.OFFLINE == tableType) {
            throw new WebApplicationException(String.format("Cannot upload low level consumer segment for OFFLINE table: %s", realtimeTableName), Response.Status.BAD_REQUEST);
        }
        if (!LLCSegmentName.isLowLevelConsumerSegmentName((String)segmentName)) {
            throw new WebApplicationException(String.format("Segment %s is not a low level consumer segment", segmentName), Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(realtimeTableName);
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableNameWithType);
        SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segmentName);
        if (segmentDataManager == null) {
            throw new WebApplicationException(String.format("Table %s segment %s does not exist", realtimeTableName, segmentName), Response.Status.NOT_FOUND);
        }
        File segmentTarFile = null;
        try {
            File segmentTarUploadDir = new File(this._serverInstance.getInstanceDataManager().getSegmentFileDirectory(), SEGMENT_UPLOAD_DIR);
            segmentTarUploadDir.mkdir();
            segmentTarFile = new File(segmentTarUploadDir, tableNameWithType + "_" + segmentName + "_" + UUID.randomUUID() + ".tar.gz");
            TarGzCompressionUtils.createTarGzFile((File)new File(tableDataManager.getTableDataDir(), segmentName), (File)segmentTarFile);
            SegmentUploader segmentUploader = this._serverInstance.getInstanceDataManager().getSegmentUploader();
            URI segmentDownloadUrl = segmentUploader.uploadSegment(segmentTarFile, new LLCSegmentName(segmentName));
            if (segmentDownloadUrl == null) {
                throw new WebApplicationException(String.format("Failed to upload table %s segment %s to segment store", realtimeTableName, segmentName), Response.Status.INTERNAL_SERVER_ERROR);
            }
            string = segmentDownloadUrl.toString();
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly(segmentTarFile);
            tableDataManager.releaseSegment(segmentDataManager);
            throw throwable;
        }
        FileUtils.deleteQuietly((File)segmentTarFile);
        tableDataManager.releaseSegment(segmentDataManager);
        return string;
    }

    @GET
    @Path(value="tables/{realtimeTableName}/consumingSegmentsInfo")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the info for consumers of this REALTIME table", notes="Get consumers info from the table data manager. Note that the partitionToOffsetMap has been deprecated and will be removed in the next release. The info is now embedded within each partition's state as currentOffsetsMap")
    public List<SegmentConsumerInfo> getConsumingSegmentsInfo(@ApiParam(value="Name of the REALTIME table", required=true) @PathParam(value="realtimeTableName") String realtimeTableName) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)realtimeTableName);
        if (TableType.OFFLINE == tableType) {
            throw new WebApplicationException("Cannot get consuming segment info for OFFLINE table: " + realtimeTableName);
        }
        String tableNameWithType = TableNameBuilder.forType((TableType)TableType.REALTIME).tableNameWithType(realtimeTableName);
        ArrayList<SegmentConsumerInfo> segmentConsumerInfoList = new ArrayList<SegmentConsumerInfo>();
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableNameWithType);
        List segmentDataManagers = tableDataManager.acquireAllSegments();
        try {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                if (!(segmentDataManager instanceof RealtimeSegmentDataManager)) continue;
                RealtimeSegmentDataManager realtimeSegmentDataManager = (RealtimeSegmentDataManager)segmentDataManager;
                Map partitionStateMap = realtimeSegmentDataManager.getConsumerPartitionState();
                HashMap recordsLagMap = new HashMap();
                HashMap availabilityLagMsMap = new HashMap();
                realtimeSegmentDataManager.getPartitionToLagState(partitionStateMap).forEach((k, v) -> {
                    recordsLagMap.put(k, v.getRecordsLag());
                    availabilityLagMsMap.put(k, v.getAvailabilityLagMs());
                });
                Map partitiionToOffsetMap = realtimeSegmentDataManager.getPartitionToCurrentOffset();
                segmentConsumerInfoList.add(new SegmentConsumerInfo(segmentDataManager.getSegmentName(), realtimeSegmentDataManager.getConsumerState().toString(), realtimeSegmentDataManager.getLastConsumedTimestamp(), partitiionToOffsetMap, new SegmentConsumerInfo.PartitionOffsetInfo(partitiionToOffsetMap, partitionStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConsumerPartitionState)e.getValue()).getUpstreamLatestOffset().toString())), recordsLagMap, availabilityLagMsMap)));
            }
        }
        catch (Exception e2) {
            throw new WebApplicationException("Caught exception when getting consumer info for table: " + realtimeTableName);
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        return segmentConsumerInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @GET
    @Path(value="tables/{tableNameWithType}/allSegmentsLoaded")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validates if the ideal state matches with the segment state on this server", notes="Validates if the ideal state matches with the segment state on this server")
    public TableSegmentValidationInfo validateTableSegmentState(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableNameWithType") String tableNameWithType) {
        tableIdealState = HelixHelper.getTableIdealState((HelixManager)this._serverInstance.getHelixManager(), (String)tableNameWithType);
        tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableNameWithType);
        maxEndTimeMs = -1L;
        instanceStatesMap = tableIdealState.getRecord().getMapFields();
lbl5:
        // 7 sources

        block13: for (Map.Entry<K, V> entry : instanceStatesMap.entrySet()) {
            segmentState = (String)((Map)entry.getValue()).get(this._instanceId);
            if (segmentState == null) continue;
            segmentName = (String)entry.getKey();
            segmentDataManager = tableDataManager.acquireSegment(segmentName);
            try {
                var12_11 = segmentState;
                var13_12 = -1;
                switch (var12_11.hashCode()) {
                    case -1929373287: {
                        if (!var12_11.equals("CONSUMING")) break;
                        var13_12 = 0;
                        break;
                    }
                    case -1958892973: {
                        if (!var12_11.equals("ONLINE")) break;
                        var13_12 = 1;
                    }
                }
                switch (var13_12) {
                    case 0: {
                        if (segmentDataManager != null) ** break;
                        var14_13 = new TableSegmentValidationInfo(false, -1L);
                        return var14_13;
                    }
                    case 1: {
                        zkMetadata = ZKMetadataProvider.getSegmentZKMetadata((ZkHelixPropertyStore)this._serverInstance.getHelixManager().getHelixPropertyStore(), (String)tableNameWithType, (String)segmentName);
                        Preconditions.checkState((boolean)(zkMetadata != null), (Object)("Segment zk metadata not found for segment : " + segmentName));
                        if (segmentDataManager == null || !segmentDataManager.getSegment().getSegmentMetadata().getCrc().equals(String.valueOf(zkMetadata.getCrc()))) {
                            var15_14 = new TableSegmentValidationInfo(false, -1L);
                            return var15_14;
                        }
                        maxEndTimeMs = Math.max(maxEndTimeMs, zkMetadata.getEndTimeMs());
                        ** break;
                    }
                    ** default:
lbl35:
                    // 1 sources

                    continue block13;
                }
            }
            finally {
                if (segmentDataManager == null) continue;
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        return new TableSegmentValidationInfo(true, maxEndTimeMs);
    }
}

