/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.restlet.resources.ResourceUtils;
import org.apache.pinot.common.restlet.resources.SegmentSizeInfo;
import org.apache.pinot.common.restlet.resources.TableSizeInfo;
import org.apache.pinot.core.data.manager.InstanceDataManager;
import org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.server.starter.ServerInstance;

@Api(tags={"Table"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class TableSizeResource {
    @Inject
    private ServerInstance _serverInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/size")
    @ApiOperation(value="Show table storage size", notes="Lists size of all the segments of the table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Table not found")})
    public String getTableSize(@ApiParam(value="Table Name with type", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Provide detailed information") @DefaultValue(value="true") @QueryParam(value="detailed") boolean detailed) throws WebApplicationException {
        InstanceDataManager instanceDataManager = this._serverInstance.getInstanceDataManager();
        if (instanceDataManager == null) {
            throw new WebApplicationException("Invalid server initialization", Response.Status.INTERNAL_SERVER_ERROR);
        }
        TableDataManager tableDataManager = instanceDataManager.getTableDataManager(tableName);
        if (tableDataManager == null) {
            throw new WebApplicationException("Table: " + tableName + " is not found", Response.Status.NOT_FOUND);
        }
        long tableSizeInBytes = 0L;
        ArrayList<SegmentSizeInfo> segmentSizeInfos = new ArrayList<SegmentSizeInfo>();
        List segmentDataManagers = tableDataManager.acquireAllSegments();
        try {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                if (!(segmentDataManager instanceof ImmutableSegmentDataManager)) continue;
                ImmutableSegment immutableSegment = (ImmutableSegment)segmentDataManager.getSegment();
                long segmentSizeBytes = immutableSegment.getSegmentSizeBytes();
                if (detailed) {
                    segmentSizeInfos.add(new SegmentSizeInfo(immutableSegment.getSegmentName(), segmentSizeBytes));
                }
                tableSizeInBytes += segmentSizeBytes;
            }
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        TableSizeInfo tableSizeInfo = new TableSizeInfo(tableDataManager.getTableName(), tableSizeInBytes, segmentSizeInfos);
        return ResourceUtils.convertToJsonString((Object)tableSizeInfo);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/table/{tableName}/size")
    @ApiOperation(value="Show table storage size", notes="Lists size of all the segments of the table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Table not found")})
    @Deprecated
    public String getTableSizeOld(@ApiParam(value="Table Name with type", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="Provide detailed information") @DefaultValue(value="true") @QueryParam(value="detailed") boolean detailed) throws WebApplicationException {
        return this.getTableSize(tableName, detailed);
    }
}

