/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
public class ShutDownFilter
implements ContainerRequestFilter {
    @Inject
    private AtomicBoolean _shutDownInProgress;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!(!this._shutDownInProgress.get() || requestContext.getMethod().equals("GET") && requestContext.getUriInfo().getPath().equals("health/liveness"))) {
            throw new WebApplicationException("Server is shutting down", Response.Status.SERVICE_UNAVAILABLE);
        }
    }
}

