/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;
import org.apache.pinot.spi.utils.JsonUtils;

public class SegmentMetadataFetcher {
    private static final String COLUMN_INDEX_KEY = "indexes";
    private static final String STAR_TREE_INDEX_KEY = "star-tree-index";
    private static final String BLOOM_FILTER = "bloom-filter";
    private static final String DICTIONARY = "dictionary";
    private static final String FORWARD_INDEX = "forward-index";
    private static final String INVERTED_INDEX = "inverted-index";
    private static final String NULL_VALUE_VECTOR_READER = "null-value-vector-reader";
    private static final String RANGE_INDEX = "range-index";
    private static final String JSON_INDEX = "json-index";
    private static final String INDEX_NOT_AVAILABLE = "NO";
    private static final String INDEX_AVAILABLE = "YES";
    private static final String STAR_TREE_DIMENSION_COLUMNS = "dimension-columns";
    private static final String STAR_TREE_METRIC_AGGREGATIONS = "metric-aggregations";
    private static final String STAR_TREE_MAX_LEAF_RECORDS = "max-leaf-records";
    private static final String STAR_TREE_DIMENSION_COLUMNS_SKIPPED = "dimension-columns-skipped";

    private SegmentMetadataFetcher() {
    }

    public static String getSegmentMetadata(SegmentDataManager segmentDataManager, List<String> columns) throws JsonProcessingException {
        IndexSegment segment = segmentDataManager.getSegment();
        SegmentMetadata segmentMetadata = segment.getSegmentMetadata();
        Set<String> columnSet = columns.size() == 1 && columns.get(0).equals("*") ? segment.getPhysicalColumnNames() : new HashSet<String>(columns);
        ObjectNode segmentMetadataJson = (ObjectNode)segmentMetadata.toJson(columnSet);
        segmentMetadataJson.set(COLUMN_INDEX_KEY, JsonUtils.objectToJsonNode(SegmentMetadataFetcher.getIndexesForSegmentColumns(segmentDataManager, columnSet)));
        segmentMetadataJson.set(STAR_TREE_INDEX_KEY, JsonUtils.objectToJsonNode(SegmentMetadataFetcher.getStarTreeIndexesForSegment(segmentDataManager)));
        return JsonUtils.objectToString((Object)segmentMetadataJson);
    }

    private static Map<String, Map<String, String>> getIndexesForSegmentColumns(SegmentDataManager segmentDataManager, @Nullable Set<String> columnSet) {
        IndexSegment segment = segmentDataManager.getSegment();
        LinkedHashMap<String, Map<String, String>> columnIndexMap = new LinkedHashMap<String, Map<String, String>>();
        for (String physicalColumnName : segment.getPhysicalColumnNames()) {
            if (columnSet != null && !columnSet.contains(physicalColumnName)) continue;
            DataSource dataSource = segment.getDataSource(physicalColumnName);
            columnIndexMap.put(physicalColumnName, SegmentMetadataFetcher.getColumnIndexes(dataSource));
        }
        return columnIndexMap;
    }

    private static Map<String, String> getColumnIndexes(DataSource dataSource) {
        LinkedHashMap<String, String> indexStatus = new LinkedHashMap<String, String>();
        if (Objects.isNull(dataSource.getBloomFilter())) {
            indexStatus.put(BLOOM_FILTER, INDEX_NOT_AVAILABLE);
        } else {
            indexStatus.put(BLOOM_FILTER, INDEX_AVAILABLE);
        }
        if (Objects.isNull(dataSource.getDictionary())) {
            indexStatus.put(DICTIONARY, INDEX_NOT_AVAILABLE);
        } else {
            indexStatus.put(DICTIONARY, INDEX_AVAILABLE);
        }
        if (Objects.isNull(dataSource.getForwardIndex())) {
            indexStatus.put(FORWARD_INDEX, INDEX_NOT_AVAILABLE);
        } else {
            indexStatus.put(FORWARD_INDEX, INDEX_AVAILABLE);
        }
        if (Objects.isNull(dataSource.getInvertedIndex())) {
            indexStatus.put(INVERTED_INDEX, INDEX_NOT_AVAILABLE);
        } else {
            indexStatus.put(INVERTED_INDEX, INDEX_AVAILABLE);
        }
        if (Objects.isNull(dataSource.getNullValueVector())) {
            indexStatus.put(NULL_VALUE_VECTOR_READER, INDEX_NOT_AVAILABLE);
        } else {
            indexStatus.put(NULL_VALUE_VECTOR_READER, INDEX_AVAILABLE);
        }
        if (Objects.isNull(dataSource.getRangeIndex())) {
            indexStatus.put(RANGE_INDEX, INDEX_NOT_AVAILABLE);
        } else {
            indexStatus.put(RANGE_INDEX, INDEX_AVAILABLE);
        }
        if (Objects.isNull(dataSource.getJsonIndex())) {
            indexStatus.put(JSON_INDEX, INDEX_NOT_AVAILABLE);
        } else {
            indexStatus.put(JSON_INDEX, INDEX_AVAILABLE);
        }
        return indexStatus;
    }

    @Nullable
    private static List<Map<String, Object>> getStarTreeIndexesForSegment(SegmentDataManager segmentDataManager) {
        List starTrees = segmentDataManager.getSegment().getStarTrees();
        return starTrees != null ? SegmentMetadataFetcher.getStarTreeIndexes(starTrees) : null;
    }

    private static List<Map<String, Object>> getStarTreeIndexes(List<StarTreeV2> starTrees) {
        ArrayList<Map<String, Object>> startreeDetails = new ArrayList<Map<String, Object>>();
        for (StarTreeV2 starTree : starTrees) {
            StarTreeV2Metadata starTreeMetadata = starTree.getMetadata();
            LinkedHashMap<String, Object> starTreeIndexMap = new LinkedHashMap<String, Object>();
            List starTreeDimensions = starTreeMetadata.getDimensionsSplitOrder();
            starTreeIndexMap.put(STAR_TREE_DIMENSION_COLUMNS, starTreeDimensions);
            ArrayList<String> starTreeMetricAggregations = new ArrayList<String>();
            Set functionColumnPairs = starTreeMetadata.getFunctionColumnPairs();
            for (AggregationFunctionColumnPair functionColumnPair : functionColumnPairs) {
                starTreeMetricAggregations.add(functionColumnPair.toColumnName());
            }
            starTreeIndexMap.put(STAR_TREE_METRIC_AGGREGATIONS, starTreeMetricAggregations);
            starTreeIndexMap.put(STAR_TREE_MAX_LEAF_RECORDS, starTreeMetadata.getMaxLeafRecords());
            starTreeIndexMap.put(STAR_TREE_DIMENSION_COLUMNS_SKIPPED, starTreeMetadata.getSkipStarNodeCreationForDimensions());
            startreeDetails.add(starTreeIndexMap);
        }
        return startreeDetails;
    }
}

