/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.core.query.utils.QueryIdUtils;
import org.apache.pinot.core.transport.InstanceRequestHandler;
import org.apache.pinot.server.starter.ServerInstance;

@Api(tags={"Query"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class QueryResource {
    @Inject
    private ServerInstance _serverInstance;

    @DELETE
    @Path(value="/query/{queryId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Cancel a query running on the server as identified by the queryId", notes="No effect if no query exists for the given queryId. Query may continue to run for a short while after calling cancel as it's done in a non-blocking manner. The cancel API can be called multiple times.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Query not found running on the server")})
    public String cancelQuery(@ApiParam(value="QueryId as in the format of <brokerId>_<requestId> or <brokerId>_<requestId>_(O|R)", required=true) @PathParam(value="queryId") String queryId) {
        try {
            boolean queryCancelled;
            InstanceRequestHandler requestHandler = this._serverInstance.getInstanceRequestHandler();
            if (QueryIdUtils.hasTypeSuffix((String)queryId)) {
                queryCancelled = requestHandler.cancelQuery(queryId);
            } else {
                boolean offlineQueryCancelled = requestHandler.cancelQuery(QueryIdUtils.withOfflineSuffix((String)queryId));
                boolean realtimeQueryCancelled = requestHandler.cancelQuery(QueryIdUtils.withRealtimeSuffix((String)queryId));
                queryCancelled = offlineQueryCancelled | realtimeQueryCancelled;
            }
            if (queryCancelled) {
                return "Cancelled query: " + queryId;
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("Failed to cancel query: %s on the server due to error: %s", queryId, e.getMessage())).build());
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)String.format("Query: %s not found on the server", queryId)).build());
    }

    @GET
    @Path(value="/queries/id")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get queryIds of running queries on the server", notes="QueryIds are in the format of <brokerId>_<requestId>_(O|R)")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Set<String> getRunningQueryIds() {
        try {
            return this._serverInstance.getInstanceRequestHandler().getRunningQueryIds();
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Failed to get queryIds of running queries on the server due to error: " + e.getMessage())).build());
        }
    }
}

