/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.utils.LoggerFileServer;
import org.apache.pinot.common.utils.LoggerUtils;

@Api(tags={"Logger"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotServerLogger {
    @Inject
    private LoggerFileServer _loggerFileServer;

    @GET
    @Path(value="/loggers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all the loggers", notes="Return all the logger names")
    public List<String> getLoggers() {
        return LoggerUtils.getAllLoggers();
    }

    @GET
    @Path(value="/loggers/{loggerName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get logger configs", notes="Return logger info")
    public Map<String, String> getLogger(@ApiParam(value="Logger name", required=true) @PathParam(value="loggerName") String loggerName) {
        Map loggerInfo = LoggerUtils.getLoggerInfo((String)loggerName);
        if (loggerInfo == null) {
            throw new WebApplicationException(String.format("Logger %s not found", loggerName), Response.Status.NOT_FOUND);
        }
        return loggerInfo;
    }

    @PUT
    @Path(value="/loggers/{loggerName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Set logger level", notes="Set logger level for a given logger")
    public Map<String, String> setLoggerLevel(@ApiParam(value="Logger name") @PathParam(value="loggerName") String loggerName, @ApiParam(value="Logger level") @QueryParam(value="level") String level) {
        return LoggerUtils.setLoggerLevel((String)loggerName, (String)level);
    }

    @GET
    @Path(value="/loggers/files")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all local log files")
    public Set<String> getLocalLogFiles() {
        try {
            if (this._loggerFileServer == null) {
                throw new WebApplicationException("Root log directory doesn't exist", Response.Status.INTERNAL_SERVER_ERROR);
            }
            return this._loggerFileServer.getAllPaths();
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/loggers/download")
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Download a log file")
    public Response downloadLogFile(@ApiParam(value="Log file path", required=true) @QueryParam(value="filePath") String filePath) {
        if (this._loggerFileServer == null) {
            throw new WebApplicationException("Root log directory is not configured", Response.Status.INTERNAL_SERVER_ERROR);
        }
        return this._loggerFileServer.downloadLogFile(filePath);
    }
}

