/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import org.apache.pinot.common.utils.PinotAppConfigs;
import org.apache.pinot.spi.env.PinotConfiguration;

@Api(tags={"AppConfigs"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/")
public class PinotServerAppConfigs {
    @Context
    private Application _application;

    @GET
    @Path(value="/appconfigs")
    @Produces(value={"application/json"})
    public String getAppConfigs() {
        PinotConfiguration pinotConfiguration = (PinotConfiguration)this._application.getProperties().get("pinotConfiguration");
        PinotAppConfigs pinotAppConfigs = new PinotAppConfigs(pinotConfiguration);
        return pinotAppConfigs.toJSONString();
    }
}

