/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.ServiceStatus;

@Api(tags={"Health"})
@Path(value="/")
public class HealthCheckResource {
    @Inject
    @Named(value="serverInstanceId")
    private String _instanceId;
    @Inject
    private ServerMetrics _serverMetrics;

    @GET
    @Path(value="/health")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Checking server health")
    @ApiResponses(value={@ApiResponse(code=200, message="Server is healthy"), @ApiResponse(code=503, message="Server is not healthy")})
    public String checkHealth(@ApiParam(value="health check type: liveness or readiness") @QueryParam(value="checkType") String checkType) {
        if ("liveness".equalsIgnoreCase(checkType)) {
            return "OK";
        }
        return this.getReadinessStatus();
    }

    @GET
    @Path(value="/health/liveness")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Checking server liveness status.")
    @ApiResponses(value={@ApiResponse(code=200, message="Server is live"), @ApiResponse(code=503, message="Server is not live")})
    public String checkLiveness() {
        return "OK";
    }

    @GET
    @Path(value="/health/readiness")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Checking server readiness status")
    @ApiResponses(value={@ApiResponse(code=200, message="Server is ready to serve queries"), @ApiResponse(code=503, message="Server is not ready to serve queries")})
    public String checkReadiness() {
        return this.getReadinessStatus();
    }

    private String getReadinessStatus() throws WebApplicationException {
        ServiceStatus.Status status = ServiceStatus.getServiceStatus((String)this._instanceId);
        if (status == ServiceStatus.Status.GOOD) {
            this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.READINESS_CHECK_OK_CALLS, 1L);
            return "OK";
        }
        this._serverMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ServerMeter.READINESS_CHECK_BAD_CALLS, 1L);
        String errMessage = String.format("Pinot server status is %s", status);
        Response response = Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)errMessage).build();
        throw new WebApplicationException(errMessage, response);
    }
}

