/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import com.fasterxml.jackson.core.JsonProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.pinot.server.api.resources.ErrorInfo;
import org.apache.pinot.spi.utils.JsonUtils;

@Provider
public class DefaultExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    public Response toResponse(WebApplicationException exception) {
        Response.ResponseBuilder builder = Response.status((int)exception.getResponse().getStatus()).entity((Object)this.toJson(exception)).type("application/json");
        return builder.build();
    }

    private String toJson(WebApplicationException exception) {
        ErrorInfo errorInfo = new ErrorInfo(exception);
        try {
            return JsonUtils.objectToString((Object)errorInfo);
        }
        catch (JsonProcessingException e) {
            return "{\"message\":\"Error converting error message: " + e.getMessage() + " to string\"}";
        }
    }
}

