/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiKeyAuthDefinition;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.SecurityDefinition;
import io.swagger.annotations.SwaggerDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.restlet.resources.SegmentConsumerInfo;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.common.restlet.resources.SegmentServerDebugInfo;
import org.apache.pinot.core.data.manager.offline.ImmutableSegmentDataManager;
import org.apache.pinot.core.data.manager.realtime.RealtimeSegmentDataManager;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.server.api.resources.ServerResourceUtils;
import org.apache.pinot.server.starter.ServerInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.stream.ConsumerPartitionState;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

@Api(tags={"Debug"}, authorizations={@Authorization(value="oauth")})
@SwaggerDefinition(securityDefinition=@SecurityDefinition(apiKeyAuthDefinitions={@ApiKeyAuthDefinition(name="Authorization", in=ApiKeyAuthDefinition.ApiKeyLocation.HEADER, key="oauth")}))
@Path(value="/debug/")
public class DebugResource {
    @Inject
    private ServerInstance _serverInstance;

    @GET
    @Path(value="tables/{tableName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get segments debug info for this table", notes="This is a debug endpoint, and won't maintain backward compatibility")
    public List<SegmentServerDebugInfo> getSegmentsDebugInfo(@ApiParam(value="Name of the table (with type)", required=true) @PathParam(value="tableName") String tableNameWithType) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        return this.getSegmentServerDebugInfo(tableNameWithType, tableType);
    }

    @GET
    @Path(value="segments/{tableName}/{segmentName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get segment debug info", notes="This is a debug endpoint, and won't maintain backward compatibility")
    public SegmentServerDebugInfo getSegmentDebugInfo(@ApiParam(value="Name of the table (with type)", required=true) @PathParam(value="tableName") String tableNameWithType, @ApiParam(value="Name of the segment", required=true) @PathParam(value="segmentName") String segmentName) {
        TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableNameWithType);
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableNameWithType);
        Map segmentErrorsMap = tableDataManager.getSegmentErrors();
        SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segmentName);
        try {
            SegmentConsumerInfo segmentConsumerInfo = this.getSegmentConsumerInfo(segmentDataManager, tableType);
            long segmentSize = this.getSegmentSize(segmentDataManager);
            SegmentErrorInfo segmentErrorInfo = (SegmentErrorInfo)segmentErrorsMap.get(segmentName);
            SegmentServerDebugInfo segmentServerDebugInfo = new SegmentServerDebugInfo(segmentName, FileUtils.byteCountToDisplaySize((long)segmentSize), segmentConsumerInfo, segmentErrorInfo);
            return segmentServerDebugInfo;
        }
        catch (Exception e) {
            throw new WebApplicationException("Caught exception when getting consumer info for table: " + tableNameWithType + " segment: " + segmentName);
        }
        finally {
            if (segmentDataManager != null) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
    }

    private List<SegmentServerDebugInfo> getSegmentServerDebugInfo(String tableNameWithType, TableType tableType) {
        String segmentName;
        ArrayList<SegmentServerDebugInfo> segmentServerDebugInfos = new ArrayList<SegmentServerDebugInfo>();
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableNameWithType);
        Map segmentErrorsMap = tableDataManager.getSegmentErrors();
        HashSet<String> segmentsWithDataManagers = new HashSet<String>();
        List segmentDataManagers = tableDataManager.acquireAllSegments();
        try {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                segmentName = segmentDataManager.getSegmentName();
                segmentsWithDataManagers.add(segmentName);
                SegmentConsumerInfo segmentConsumerInfo = this.getSegmentConsumerInfo(segmentDataManager, tableType);
                long segmentSize = this.getSegmentSize(segmentDataManager);
                SegmentErrorInfo segmentErrorInfo = (SegmentErrorInfo)segmentErrorsMap.get(segmentName);
                segmentServerDebugInfos.add(new SegmentServerDebugInfo(segmentName, FileUtils.byteCountToDisplaySize((long)segmentSize), segmentConsumerInfo, segmentErrorInfo));
            }
        }
        catch (Exception e) {
            throw new WebApplicationException("Caught exception when getting consumer info for table: " + tableNameWithType);
        }
        finally {
            for (SegmentDataManager segmentDataManager : segmentDataManagers) {
                tableDataManager.releaseSegment(segmentDataManager);
            }
        }
        for (Map.Entry entry : segmentErrorsMap.entrySet()) {
            segmentName = (String)entry.getKey();
            if (segmentsWithDataManagers.contains(segmentName)) continue;
            SegmentErrorInfo segmentErrorInfo = (SegmentErrorInfo)entry.getValue();
            segmentServerDebugInfos.add(new SegmentServerDebugInfo(segmentName, null, null, segmentErrorInfo));
        }
        return segmentServerDebugInfos;
    }

    private long getSegmentSize(SegmentDataManager segmentDataManager) {
        return segmentDataManager instanceof ImmutableSegmentDataManager ? ((ImmutableSegment)segmentDataManager.getSegment()).getSegmentSizeBytes() : 0L;
    }

    private SegmentConsumerInfo getSegmentConsumerInfo(SegmentDataManager segmentDataManager, TableType tableType) {
        SegmentConsumerInfo segmentConsumerInfo = null;
        if (tableType == TableType.REALTIME) {
            RealtimeSegmentDataManager realtimeSegmentDataManager = (RealtimeSegmentDataManager)segmentDataManager;
            Map partitionStateMap = realtimeSegmentDataManager.getConsumerPartitionState();
            Map currentOffsets = realtimeSegmentDataManager.getPartitionToCurrentOffset();
            Map<String, String> upstreamLatest = partitionStateMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConsumerPartitionState)e.getValue()).getUpstreamLatestOffset().toString()));
            HashMap recordsLagMap = new HashMap();
            HashMap availabilityLagMsMap = new HashMap();
            realtimeSegmentDataManager.getPartitionToLagState(partitionStateMap).forEach((k, v) -> {
                recordsLagMap.put(k, v.getRecordsLag());
                availabilityLagMsMap.put(k, v.getAvailabilityLagMs());
            });
            segmentConsumerInfo = new SegmentConsumerInfo(segmentDataManager.getSegmentName(), realtimeSegmentDataManager.getConsumerState().toString(), realtimeSegmentDataManager.getLastConsumedTimestamp(), currentOffsets, new SegmentConsumerInfo.PartitionOffsetInfo(currentOffsets, upstreamLatest, recordsLagMap, availabilityLagMsMap));
        }
        return segmentConsumerInfo;
    }
}

