/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.server.api.resources.ServerResourceUtils;
import org.apache.pinot.server.starter.ServerInstance;
import org.apache.pinot.server.starter.helix.SegmentReloadStatusValue;
import org.apache.pinot.spi.utils.JsonUtils;

@Api(tags={"Tasks"})
@Path(value="/")
public class ControllerJobStatusResource {
    @Inject
    private ServerInstance _serverInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/controllerJob/reloadStatus/{tableNameWithType}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Task status", notes="Return the status of a given reload job")
    public String reloadJobStatus(@PathParam(value="tableNameWithType") String tableNameWithType, @QueryParam(value="reloadJobTimestamp") long reloadJobSubmissionTimestamp, @QueryParam(value="segmentName") String segmentName) throws Exception {
        TableDataManager tableDataManager = ServerResourceUtils.checkGetTableDataManager(this._serverInstance, tableNameWithType);
        if (segmentName == null) {
            List allSegments = tableDataManager.acquireAllSegments();
            try {
                long successCount = 0L;
                for (SegmentDataManager segmentDataManager : allSegments) {
                    if (segmentDataManager.getLoadTimeMs() < reloadJobSubmissionTimestamp) continue;
                    ++successCount;
                }
                SegmentReloadStatusValue segmentReloadStatusValue = new SegmentReloadStatusValue(allSegments.size(), successCount);
                String string = JsonUtils.objectToString((Object)segmentReloadStatusValue);
                return string;
            }
            finally {
                for (SegmentDataManager segmentDataManager : allSegments) {
                    tableDataManager.releaseSegment(segmentDataManager);
                }
            }
        }
        SegmentDataManager segmentDataManager = tableDataManager.acquireSegment(segmentName);
        if (segmentDataManager == null) {
            return JsonUtils.objectToString((Object)new SegmentReloadStatusValue(0L, 0L));
        }
        try {
            int successCount = 0;
            if (segmentDataManager.getLoadTimeMs() >= reloadJobSubmissionTimestamp) {
                successCount = 1;
            }
            SegmentReloadStatusValue segmentReloadStatusValue = new SegmentReloadStatusValue(1L, successCount);
            String string = JsonUtils.objectToString((Object)segmentReloadStatusValue);
            return string;
        }
        finally {
            tableDataManager.releaseSegment(segmentDataManager);
        }
    }
}

