/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.api;

import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LoggerFileServer;
import org.apache.pinot.core.transport.ListenerConfig;
import org.apache.pinot.core.util.ListenerConfigUtil;
import org.apache.pinot.server.access.AccessControlFactory;
import org.apache.pinot.server.starter.ServerInstance;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.PinotReflectionUtils;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminApiApplication
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminApiApplication.class);
    public static final String PINOT_CONFIGURATION = "pinotConfiguration";
    public static final String RESOURCE_PACKAGE = "org.apache.pinot.server.api.resources";
    public static final String SERVER_INSTANCE_ID = "serverInstanceId";
    private final AtomicBoolean _shutDownInProgress = new AtomicBoolean();
    private final ServerInstance _serverInstance;
    private HttpServer _httpServer;

    public AdminApiApplication(ServerInstance instance, final AccessControlFactory accessControlFactory, final PinotConfiguration serverConf) {
        this._serverInstance = instance;
        this.packages(new String[]{RESOURCE_PACKAGE});
        this.property(PINOT_CONFIGURATION, serverConf);
        this.register(new AbstractBinder(){

            protected void configure() {
                this.bind(AdminApiApplication.this._shutDownInProgress).to(AtomicBoolean.class);
                this.bind(AdminApiApplication.this._serverInstance).to(ServerInstance.class);
                this.bind(AdminApiApplication.this._serverInstance.getServerMetrics()).to(ServerMetrics.class);
                this.bind(accessControlFactory).to(AccessControlFactory.class);
                this.bind(serverConf.getProperty("pinot.server.instance.id")).named(AdminApiApplication.SERVER_INSTANCE_ID);
                String loggerRootDir = serverConf.getProperty("pinot.server.logger.root.dir");
                if (loggerRootDir != null) {
                    this.bind(new LoggerFileServer(loggerRootDir)).to(LoggerFileServer.class);
                }
            }
        });
        this.register(JacksonFeature.class);
        this.registerClasses(new Class[]{ApiListingResource.class});
        this.registerClasses(new Class[]{SwaggerSerializers.class});
        this.register(new ContainerResponseFilter(){

            public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
                containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
            }
        });
    }

    public boolean start(List<ListenerConfig> listenerConfigs) {
        this._httpServer = ListenerConfigUtil.buildHttpServer((ResourceConfig)this, listenerConfigs);
        try {
            this._httpServer.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start http server", e);
        }
        PinotConfiguration pinotConfiguration = (PinotConfiguration)this.getProperties().get(PINOT_CONFIGURATION);
        if (pinotConfiguration.getProperty("pinot.server.swagger.enabled", true)) {
            LOGGER.info("Starting swagger for the Pinot server.");
            PinotReflectionUtils.runWithLock(() -> this.setupSwagger(pinotConfiguration));
        }
        return true;
    }

    private void setupSwagger(PinotConfiguration pinotConfiguration) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle("Pinot Server API");
        beanConfig.setDescription("APIs for accessing Pinot server information");
        beanConfig.setContact("https://github.com/apache/pinot");
        beanConfig.setVersion("1.0");
        beanConfig.setExpandSuperTypes(false);
        if (Boolean.parseBoolean(pinotConfiguration.getProperty("pinot.server.swagger.use.https"))) {
            beanConfig.setSchemes(new String[]{"https"});
        } else {
            beanConfig.setSchemes(new String[]{"http", "https"});
        }
        beanConfig.setBasePath("/");
        beanConfig.setResourcePackage(RESOURCE_PACKAGE);
        beanConfig.setScan(true);
        try {
            beanConfig.setHost(InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot get localhost name");
        }
        CLStaticHttpHandler staticHttpHandler = new CLStaticHttpHandler(AdminApiApplication.class.getClassLoader(), new String[]{"/api/"});
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/api/"});
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)staticHttpHandler, new String[]{"/help/"});
        URL swaggerDistLocation = AdminApiApplication.class.getClassLoader().getResource("META-INF/resources/webjars/swagger-ui/3.23.11/");
        CLStaticHttpHandler swaggerDist = new CLStaticHttpHandler((ClassLoader)new URLClassLoader(new URL[]{swaggerDistLocation}), new String[0]);
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)swaggerDist, new String[]{"/swaggerui-dist/"});
    }

    public void startShuttingDown() {
        this._shutDownInProgress.set(true);
    }

    public void stop() {
        this._httpServer.shutdownNow();
    }
}

