/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.data.TimeConversions;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;

public class AvroSchemaUtil {
    private static final String DECIMAL = "decimal";
    private static final String UUID = "uuid";
    private static final String DATE = "date";
    private static final String TIME_MILLIS = "time-millis";
    private static final String TIME_MICROS = "time-micros";
    private static final String TIMESTAMP_MILLIS = "timestamp-millis";
    private static final String TIMESTAMP_MICROS = "timestamp-micros";
    private static final Map<String, Conversion<?>> CONVERSION_MAP = new HashMap();

    private AvroSchemaUtil() {
    }

    public static Conversion<?> findConversionFor(String typeName) {
        return CONVERSION_MAP.get(typeName);
    }

    public static FieldSpec.DataType valueOf(Schema.Type avroType) {
        switch (avroType) {
            case INT: {
                return FieldSpec.DataType.INT;
            }
            case LONG: {
                return FieldSpec.DataType.LONG;
            }
            case FLOAT: {
                return FieldSpec.DataType.FLOAT;
            }
            case DOUBLE: {
                return FieldSpec.DataType.DOUBLE;
            }
            case BOOLEAN: {
                return FieldSpec.DataType.BOOLEAN;
            }
            case STRING: 
            case ENUM: {
                return FieldSpec.DataType.STRING;
            }
            case BYTES: 
            case FIXED: {
                return FieldSpec.DataType.BYTES;
            }
            case MAP: 
            case ARRAY: 
            case RECORD: 
            case UNION: {
                return FieldSpec.DataType.JSON;
            }
        }
        throw new UnsupportedOperationException("Unsupported Avro type: " + avroType);
    }

    public static boolean isPrimitiveType(Schema.Type avroType) {
        switch (avroType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: 
            case STRING: 
            case ENUM: {
                return true;
            }
        }
        return false;
    }

    public static ObjectNode toAvroSchemaJsonObject(FieldSpec fieldSpec) {
        ObjectNode jsonSchema = JsonUtils.newObjectNode();
        jsonSchema.put("name", fieldSpec.getName());
        switch (fieldSpec.getDataType().getStoredType()) {
            case INT: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "int"));
                return jsonSchema;
            }
            case LONG: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "long"));
                return jsonSchema;
            }
            case FLOAT: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "float"));
                return jsonSchema;
            }
            case DOUBLE: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "double"));
                return jsonSchema;
            }
            case STRING: 
            case JSON: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "string"));
                return jsonSchema;
            }
            case BYTES: {
                jsonSchema.set("type", (JsonNode)AvroSchemaUtil.convertStringsToJsonArray("null", "bytes"));
                return jsonSchema;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static ArrayNode convertStringsToJsonArray(String ... strings) {
        ArrayNode jsonArray = JsonUtils.newArrayNode();
        for (String string : strings) {
            jsonArray.add(string);
        }
        return jsonArray;
    }

    public static Object applyLogicalType(Schema.Field field, Object value) {
        if (field == null || field.schema() == null) {
            return value;
        }
        LogicalType logicalType = LogicalTypes.fromSchemaIgnoreInvalid((Schema)field.schema());
        if (logicalType == null) {
            return value;
        }
        Conversion<?> conversion = AvroSchemaUtil.findConversionFor(logicalType.getName());
        if (conversion == null) {
            return value;
        }
        return Conversions.convertToLogicalType((Object)value, (Schema)field.schema(), (LogicalType)logicalType, conversion);
    }

    static {
        CONVERSION_MAP.put(DECIMAL, (Conversion<?>)new Conversions.DecimalConversion());
        CONVERSION_MAP.put(UUID, (Conversion<?>)new Conversions.UUIDConversion());
        CONVERSION_MAP.put(DATE, (Conversion<?>)new TimeConversions.DateConversion());
        CONVERSION_MAP.put(TIME_MILLIS, (Conversion<?>)new TimeConversions.TimeMillisConversion());
        CONVERSION_MAP.put(TIME_MICROS, (Conversion<?>)new TimeConversions.TimeMicrosConversion());
        CONVERSION_MAP.put(TIMESTAMP_MILLIS, (Conversion<?>)new TimeConversions.TimestampMillisConversion());
        CONVERSION_MAP.put(TIMESTAMP_MICROS, (Conversion<?>)new TimeConversions.TimestampMicrosConversion());
    }
}

