/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.plugin.inputformat.avro;

import com.google.common.collect.ImmutableSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.pinot.plugin.inputformat.avro.AvroRecordExtractorConfig;
import org.apache.pinot.plugin.inputformat.avro.AvroSchemaUtil;
import org.apache.pinot.spi.data.readers.BaseRecordExtractor;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordExtractorConfig;

public class AvroRecordExtractor
extends BaseRecordExtractor<GenericRecord> {
    private Set<String> _fields;
    private boolean _extractAll = false;
    private boolean _applyLogicalTypes;

    public void init(@Nullable Set<String> fields, @Nullable RecordExtractorConfig recordExtractorConfig) {
        AvroRecordExtractorConfig config = (AvroRecordExtractorConfig)recordExtractorConfig;
        if (config != null) {
            this._applyLogicalTypes = config.isEnableLogicalTypes();
        }
        if (fields == null || fields.isEmpty()) {
            this._extractAll = true;
            this._fields = Collections.emptySet();
        } else {
            this._fields = ImmutableSet.copyOf(fields);
        }
    }

    public GenericRow extract(GenericRecord from, GenericRow to) {
        if (this._extractAll) {
            List fields = from.getSchema().getFields();
            for (Schema.Field field : fields) {
                String fieldName = field.name();
                Object value = from.get(fieldName);
                if (this._applyLogicalTypes) {
                    value = AvroSchemaUtil.applyLogicalType(field, value);
                }
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(fieldName, value);
            }
        } else {
            for (String fieldName : this._fields) {
                Object value = from.get(fieldName);
                if (this._applyLogicalTypes) {
                    Schema.Field field = from.getSchema().getField(fieldName);
                    value = AvroSchemaUtil.applyLogicalType(field, value);
                }
                if (value != null) {
                    value = this.convert(value);
                }
                to.putValue(fieldName, value);
            }
        }
        return to;
    }

    protected boolean isRecord(Object value) {
        return value instanceof GenericRecord;
    }

    @Nullable
    protected Object convertRecord(Object value) {
        GenericRecord record = (GenericRecord)value;
        List fields = record.getSchema().getFields();
        if (fields.isEmpty()) {
            return null;
        }
        HashMap<String, Object> convertedMap = new HashMap<String, Object>();
        for (Schema.Field field : fields) {
            String fieldName = field.name();
            Object fieldValue = record.get(fieldName);
            if (fieldValue != null) {
                fieldValue = this.convert(fieldValue);
            }
            convertedMap.put(fieldName, fieldValue);
        }
        return convertedMap;
    }

    protected Object convertSingleValue(Object value) {
        if (value instanceof Instant) {
            return Timestamp.from((Instant)value);
        }
        if (value instanceof GenericFixed) {
            return ((GenericFixed)value).bytes();
        }
        return super.convertSingleValue(value);
    }
}

