/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotatedCallable;
import org.apache.webbeans.portable.AnnotatedParameterImpl;
import org.apache.webbeans.util.GenericsUtil;

public class AnnotatedMethodImpl<X>
extends AbstractAnnotatedCallable<X>
implements AnnotatedMethod<X> {
    AnnotatedMethodImpl(WebBeansContext webBeansContext, Method javaMember, AnnotatedType<X> declaringType) {
        super(webBeansContext, GenericsUtil.resolveReturnType(declaringType.getJavaClass(), javaMember), javaMember, declaringType);
        this.setAnnotations(javaMember.getDeclaredAnnotations());
        this.setAnnotatedParameters(GenericsUtil.resolveParameterTypes(declaringType.getJavaClass(), javaMember), javaMember.getParameterAnnotations());
    }

    AnnotatedMethodImpl(WebBeansContext webBeansContext, AnnotatedMethod<? super X> originalAnnotatedMethod, AnnotatedType<X> declaringType) {
        super(webBeansContext, originalAnnotatedMethod.getBaseType(), originalAnnotatedMethod.getJavaMember(), declaringType);
        this.getAnnotations().addAll(originalAnnotatedMethod.getAnnotations());
        for (AnnotatedParameter originalAnnotatedParameter : originalAnnotatedMethod.getParameters()) {
            this.getParameters().add(new AnnotatedParameterImpl(webBeansContext, originalAnnotatedParameter, this));
        }
    }

    @Override
    protected Set<Type> extractTypeClojure(Type baseType) {
        return GenericsUtil.getDirectTypeClosure(baseType, this.getOwningClass());
    }

    @Override
    public Method getJavaMember() {
        return (Method)Method.class.cast(this.javaMember);
    }

    @Override
    public String toString() {
        return "Annotated Method '" + this.javaMember.getName() + "', " + super.toString();
    }
}

