/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.ear;

import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.ear.AbstractEarModule;
import org.apache.maven.plugin.ear.EarExecutionContext;
import org.apache.maven.plugin.ear.EarPluginException;
import org.codehaus.plexus.util.xml.XMLWriter;

public class JarModule
extends AbstractEarModule {
    private Boolean includeInApplicationXml = Boolean.FALSE;

    public JarModule() {
    }

    public JarModule(Artifact a, String defaultLibBundleDir) {
        super(a);
        this.setLibBundleDir(defaultLibBundleDir);
    }

    public void appendModule(XMLWriter writer, String version) {
        if (this.includeInApplicationXml.booleanValue()) {
            writer.startElement("module");
            writer.startElement("java");
            writer.writeText(this.getUri());
            writer.endElement();
            writer.endElement();
        }
    }

    public void resolveArtifact(Set artifacts) throws EarPluginException, MojoFailureException {
        super.resolveArtifact(artifacts);
        this.setLibBundleDir(EarExecutionContext.getInstance().getDefaultLibBundleDir());
    }

    public String getType() {
        return "jar";
    }

    private void setLibBundleDir(String defaultLibBundleDir) {
        if (defaultLibBundleDir != null && this.bundleDir == null) {
            this.bundleDir = defaultLibBundleDir;
        }
    }
}

