/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.script.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.ContextEnabled;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.apache.maven.script.ant.AntPropertyHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.component.MapOrientedComponent;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.factory.ant.AntComponentExecutionException;
import org.codehaus.plexus.component.factory.ant.AntScriptInvoker;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;

public class AntMojoWrapper
extends AbstractMojo
implements ContextEnabled,
MapOrientedComponent,
LogEnabled {
    private Map<String, Object> pluginContext;
    private final AntScriptInvoker scriptInvoker;
    private Project antProject;
    private MavenProject mavenProject;
    private MojoExecution mojoExecution;
    private MavenSession session;
    private PathTranslator pathTranslator;
    private Logger logger;
    private transient List<String> unconstructedParts = new ArrayList<String>();

    public AntMojoWrapper(AntScriptInvoker scriptInvoker) {
        this.scriptInvoker = scriptInvoker;
    }

    public void execute() throws MojoExecutionException {
        Map refs;
        if (this.antProject == null) {
            this.antProject = this.scriptInvoker.getProject();
        }
        HashMap<String, Object> allConfig = new HashMap<String, Object>();
        if (this.pluginContext != null && !this.pluginContext.isEmpty()) {
            allConfig.putAll(this.pluginContext);
        }
        if ((refs = this.scriptInvoker.getReferences()) != null) {
            allConfig.putAll(refs);
            for (Map.Entry entry : refs.entrySet()) {
                if (!((String)entry.getKey()).startsWith(PathTranslator.class.getName())) continue;
                this.pathTranslator = (PathTranslator)entry.getValue();
            }
        }
        this.mavenProject = (MavenProject)allConfig.get("project");
        this.mojoExecution = (MojoExecution)allConfig.get("mojoExecution");
        this.session = (MavenSession)allConfig.get("session");
        this.unpackFileBasedResources();
        this.addClasspathReferences();
        if (this.logger.isDebugEnabled() && !this.unconstructedParts.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("The following standard Maven Ant-mojo support objects could not be created:\n\n");
            for (String part : this.unconstructedParts) {
                buffer.append("\n-  ").append(part);
            }
            buffer.append("\n\nMaven project, session, mojo-execution, or path-translation parameter information is ");
            buffer.append("\nmissing from this mojo's plugin descriptor.");
            buffer.append("\n\nPerhaps this Ant-based mojo depends on maven-script-ant < 2.1.0, ");
            buffer.append("or used maven-plugin-tools-ant < 2.2 during release?\n\n");
            this.logger.debug(buffer.toString());
        }
        try {
            this.scriptInvoker.invoke();
        }
        catch (AntComponentExecutionException e) {
            throw new MojoExecutionException("Failed to execute: " + e.getMessage(), (Exception)((Object)e));
        }
        this.unconstructedParts.clear();
    }

    public void setPluginContext(Map pluginContext) {
        this.pluginContext = pluginContext;
    }

    public Map getPluginContext() {
        return this.pluginContext;
    }

    public void addComponentRequirement(ComponentRequirement requirementDescriptor, Object requirementValue) throws ComponentConfigurationException {
        this.scriptInvoker.addComponentRequirement(requirementDescriptor, requirementValue);
    }

    public void setComponentConfiguration(Map componentConfiguration) throws ComponentConfigurationException {
        this.scriptInvoker.setComponentConfiguration(componentConfiguration);
        this.antProject = this.scriptInvoker.getProject();
    }

    private void unpackFileBasedResources() throws MojoExecutionException {
        if (this.mojoExecution == null || this.mavenProject == null) {
            this.unconstructedParts.add("Unpacked Ant build scripts (in Maven build directory).");
            return;
        }
        PluginDescriptor pluginDescriptor = this.mojoExecution.getMojoDescriptor().getPluginDescriptor();
        File pluginJar = pluginDescriptor.getPluginArtifact().getFile();
        String resourcesPath = pluginDescriptor.getArtifactId();
        File outputDirectory = new File(this.mavenProject.getBuild().getDirectory());
        try {
            ZipUnArchiver ua = new ZipUnArchiver(pluginJar);
            ua.extract(resourcesPath, outputDirectory);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error extracting resources from your Ant-based plugin.", (Exception)((Object)e));
        }
    }

    private void addClasspathReferences() throws MojoExecutionException {
        try {
            Path p;
            if (this.mavenProject != null && this.session != null && this.pathTranslator != null) {
                PluginParameterExpressionEvaluator exprEvaluator = new PluginParameterExpressionEvaluator(this.session, this.mojoExecution, this.pathTranslator, this.logger, this.mavenProject, this.mavenProject.getProperties());
                PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)this.antProject);
                propertyHelper.setNext((PropertyHelper)new AntPropertyHelper((ExpressionEvaluator)exprEvaluator, this.mavenProject.getArtifacts(), this.getLog()));
            } else {
                this.unconstructedParts.add("Maven parameter expression evaluator for Ant properties.");
            }
            Map references = this.scriptInvoker.getReferences();
            if (this.mavenProject != null) {
                p = new Path(this.antProject);
                p.setPath(StringUtils.join(this.mavenProject.getCompileClasspathElements().iterator(), (String)File.pathSeparator));
                references.put("maven.dependency.classpath", p);
                this.antProject.addReference("maven.dependency.classpath", (Object)p);
                references.put("maven.compile.classpath", p);
                this.antProject.addReference("maven.compile.classpath", (Object)p);
                p = new Path(this.antProject);
                p.setPath(StringUtils.join(this.mavenProject.getRuntimeClasspathElements().iterator(), (String)File.pathSeparator));
                references.put("maven.runtime.classpath", p);
                this.antProject.addReference("maven.runtime.classpath", (Object)p);
                p = new Path(this.antProject);
                p.setPath(StringUtils.join(this.mavenProject.getTestClasspathElements().iterator(), (String)File.pathSeparator));
                references.put("maven.test.classpath", p);
                this.antProject.addReference("maven.test.classpath", (Object)p);
            } else {
                this.unconstructedParts.add("Maven standard project-based classpath references.");
            }
            if (this.mojoExecution != null) {
                p = this.getPathFromArtifacts(this.mojoExecution.getMojoDescriptor().getPluginDescriptor().getArtifacts(), this.antProject);
                references.put("maven.plugin.classpath", p);
                this.antProject.addReference("maven.plugin.classpath", (Object)p);
            } else {
                this.unconstructedParts.add("Maven standard plugin-based classpath references.");
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error creating classpath references for Ant-based plugin scripts.", (Exception)((Object)e));
        }
    }

    public Path getPathFromArtifacts(Collection<Artifact> artifacts, Project antProject) throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        for (Artifact a : artifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        return p;
    }

    public Project getAntProject() {
        return this.antProject;
    }

    public void setAntProject(Project antProject) {
        this.antProject = antProject;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
    }

    public MojoExecution getMojoExecution() {
        return this.mojoExecution;
    }

    public void setMojoExecution(MojoExecution mojoExecution) {
        this.mojoExecution = mojoExecution;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public PathTranslator getPathTranslator() {
        return this.pathTranslator;
    }

    public void setPathTranslator(PathTranslator pathTranslator) {
        this.pathTranslator = pathTranslator;
    }

    public AntScriptInvoker getScriptInvoker() {
        return this.scriptInvoker;
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

