/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.extractor.annotations.converter;

import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.builder.TypeAssembler;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.library.ClassNameLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import com.thoughtworks.qdox.type.TypeResolver;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.tools.plugin.extractor.annotations.converter.ConverterContext;
import org.apache.maven.tools.plugin.extractor.annotations.scanner.MojoAnnotatedClass;
import org.apache.maven.tools.plugin.javadoc.FullyQualifiedJavadocReference;
import org.apache.maven.tools.plugin.javadoc.JavadocLinkGenerator;
import org.apache.maven.tools.plugin.javadoc.JavadocReference;

public class JavaClassConverterContext
implements ConverterContext {
    final JavaClass mojoClass;
    final JavaClass declaringClass;
    final JavaProjectBuilder javaProjectBuilder;
    final Map<String, MojoAnnotatedClass> mojoAnnotatedClasses;
    final JavadocLinkGenerator linkGenerator;
    final int lineNumber;
    final Optional<JavaModule> javaModule;
    final Map<String, Object> attributes;

    public JavaClassConverterContext(JavaClass mojoClass, JavaProjectBuilder javaProjectBuilder, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, JavadocLinkGenerator linkGenerator, int lineNumber) {
        this(mojoClass, mojoClass, javaProjectBuilder, mojoAnnotatedClasses, linkGenerator, lineNumber);
    }

    public JavaClassConverterContext(JavaClass mojoClass, JavaClass declaringClass, JavaProjectBuilder javaProjectBuilder, Map<String, MojoAnnotatedClass> mojoAnnotatedClasses, JavadocLinkGenerator linkGenerator, int lineNumber) {
        this.mojoClass = mojoClass;
        this.declaringClass = declaringClass;
        this.javaProjectBuilder = javaProjectBuilder;
        this.mojoAnnotatedClasses = mojoAnnotatedClasses;
        this.linkGenerator = linkGenerator;
        this.lineNumber = lineNumber;
        this.attributes = new HashMap<String, Object>();
        this.javaModule = mojoClass.getJavaClassLibrary().getJavaModules().stream().filter(m -> m.getDescriptor().getExports().stream().anyMatch(e -> e.getSource().getName().equals(this.getPackageName()))).findFirst();
    }

    @Override
    public Optional<String> getModuleName() {
        return this.javaModule.map(JavaModule::getName);
    }

    @Override
    public String getPackageName() {
        return this.mojoClass.getPackageName();
    }

    @Override
    public String getLocation() {
        try {
            URL url = this.declaringClass.getSource().getURL();
            if (url == null) {
                return this.declaringClass.getPackageName() + this.declaringClass.getSimpleName() + ":" + this.lineNumber;
            }
            return Paths.get("", new String[0]).toUri().relativize(url.toURI()) + ":" + this.lineNumber;
        }
        catch (URISyntaxException e) {
            return this.declaringClass.getSource().getURL() + ":" + this.lineNumber;
        }
    }

    @Override
    public boolean isReferencedBy(FullyQualifiedJavadocReference reference) {
        for (JavaClass javaClassInHierarchy = this.mojoClass; javaClassInHierarchy != null; javaClassInHierarchy = javaClassInHierarchy.getSuperJavaClass()) {
            if (JavaClassConverterContext.isClassReferencedByReference(javaClassInHierarchy, reference)) {
                return true;
            }
            for (JavaClass implementedInterfaces : javaClassInHierarchy.getInterfaces()) {
                if (!JavaClassConverterContext.isClassReferencedByReference(implementedInterfaces, reference)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isClassReferencedByReference(JavaClass javaClass, FullyQualifiedJavadocReference reference) {
        return javaClass.getPackageName().equals(reference.getPackageName().orElse("")) && javaClass.getSimpleName().equals(reference.getClassName().orElse(""));
    }

    @Override
    public boolean canGetUrl() {
        return this.linkGenerator != null;
    }

    @Override
    public URI getUrl(FullyQualifiedJavadocReference reference) {
        try {
            MojoAnnotatedClass mojoAnnotatedClass;
            if (this.isReferencedBy(reference) && FullyQualifiedJavadocReference.MemberType.FIELD == reference.getMemberType().orElse(null)) {
                return new URI(null, null, reference.getMember().orElse(null));
            }
            Optional fqClassName = reference.getFullyQualifiedClassName();
            if (fqClassName.isPresent() && (mojoAnnotatedClass = this.mojoAnnotatedClasses.get(fqClassName.get())) != null && mojoAnnotatedClass.getMojo() != null && (!reference.getLabel().isPresent() || FullyQualifiedJavadocReference.MemberType.FIELD == reference.getMemberType().orElse(null))) {
                return new URI(null, "./" + mojoAnnotatedClass.getMojo().name() + "-mojo.html", reference.getMember().orElse(null));
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Error constructing a valid URL", e);
        }
        if (this.linkGenerator == null) {
            throw new IllegalStateException("No Javadoc Sites given to create URLs to");
        }
        return this.linkGenerator.createLink(reference);
    }

    @Override
    public FullyQualifiedJavadocReference resolveReference(JavadocReference reference) {
        Optional<FullyQualifiedJavadocReference> resolvedName;
        if (reference.getPackageNameClassName().isPresent() && (resolvedName = this.resolveMember((String)reference.getPackageNameClassName().get(), (Optional<String>)reference.getMember(), (Optional<String>)reference.getLabel())).isPresent()) {
            return resolvedName.get();
        }
        if (reference.getMember().isPresent() && !reference.getPackageNameClassName().isPresent()) {
            resolvedName = this.resolveMember(this.declaringClass, (Optional<String>)reference.getMember(), (Optional<String>)reference.getLabel());
            if (resolvedName.isPresent()) {
                return resolvedName.get();
            }
            for (JavaClass nestedClass : this.declaringClass.getNestedClasses()) {
                resolvedName = this.resolveMember(nestedClass, (Optional<String>)reference.getMember(), (Optional<String>)reference.getLabel());
                if (!resolvedName.isPresent()) continue;
                return resolvedName.get();
            }
            for (JavaClass superClass = this.declaringClass.getSuperJavaClass(); superClass != null; superClass = superClass.getSuperJavaClass()) {
                resolvedName = this.resolveMember(superClass, (Optional<String>)reference.getMember(), (Optional<String>)reference.getLabel());
                if (!resolvedName.isPresent()) continue;
                return resolvedName.get();
            }
        } else {
            String packageNameClassName = (String)reference.getPackageNameClassName().get();
            resolvedName = this.resolveMember(this.declaringClass.getPackageName() + "." + packageNameClassName, (Optional<String>)reference.getMember(), (Optional<String>)reference.getLabel());
            if (resolvedName.isPresent()) {
                return resolvedName.get();
            }
            ArrayList<String> importNames = new ArrayList<String>();
            importNames.add("java.lang.*");
            importNames.addAll(this.declaringClass.getSource().getImports());
            for (String importName : importNames) {
                int firstDotIndex;
                if (!(importName.endsWith(".*") ? (resolvedName = this.resolveMember(importName.replace("*", packageNameClassName), (Optional<String>)reference.getMember(), (Optional<String>)reference.getLabel())).isPresent() : (importName.endsWith(packageNameClassName) ? (resolvedName = this.resolveMember(importName, (Optional<String>)reference.getMember(), (Optional<String>)reference.getLabel())).isPresent() : (firstDotIndex = packageNameClassName.indexOf(".")) > 0 && importName.endsWith(packageNameClassName.substring(0, firstDotIndex)) && (resolvedName = this.resolveMember(importName, packageNameClassName.substring(firstDotIndex + 1), reference.getMember(), reference.getLabel())).isPresent()))) continue;
                return resolvedName.get();
            }
        }
        throw new IllegalArgumentException("Could not resolve javadoc reference " + reference);
    }

    @Override
    public String getStaticFieldValue(FullyQualifiedJavadocReference reference) {
        String fqcn = (String)reference.getFullyQualifiedClassName().orElseThrow(() -> new IllegalArgumentException("Given reference does not specify a fully qualified class name!"));
        String fieldName = (String)reference.getMember().orElseThrow(() -> new IllegalArgumentException("Given reference does not specify a member!"));
        JavaClass javaClass = this.javaProjectBuilder.getClassByName(fqcn);
        JavaField javaField = javaClass.getFieldByName(fieldName);
        if (javaField == null) {
            throw new IllegalArgumentException("Could not find field with name " + fieldName + " in class " + fqcn);
        }
        if (!javaField.isStatic()) {
            throw new IllegalArgumentException("Field with name " + fieldName + " in class " + fqcn + " is not static");
        }
        return javaField.getInitializationExpression();
    }

    @Override
    public URI getInternalJavadocSiteBaseUrl() {
        return this.linkGenerator.getInternalJavadocSiteBaseUrl();
    }

    private Optional<FullyQualifiedJavadocReference> resolveMember(String fullyQualifiedPackageNameClassName, Optional<String> member, Optional<String> label) {
        return this.resolveMember(fullyQualifiedPackageNameClassName, "", member, label);
    }

    private Optional<FullyQualifiedJavadocReference> resolveMember(String fullyQualifiedPackageNameClassName, String nestedClassName, Optional<String> member, Optional<String> label) {
        JavaClass javaClass = this.javaProjectBuilder.getClassByName(fullyQualifiedPackageNameClassName);
        if (!JavaClassConverterContext.isClassFound(javaClass)) {
            JavaPackage javaPackage = this.javaProjectBuilder.getPackageByName(fullyQualifiedPackageNameClassName);
            if (javaPackage == null || !nestedClassName.isEmpty()) {
                int lastIndexOfDot = fullyQualifiedPackageNameClassName.lastIndexOf(46);
                if (lastIndexOfDot > 0) {
                    String newNestedClassName = nestedClassName;
                    if (!newNestedClassName.isEmpty()) {
                        newNestedClassName = newNestedClassName + '.';
                    }
                    newNestedClassName = newNestedClassName + fullyQualifiedPackageNameClassName.substring(lastIndexOfDot + 1);
                    return this.resolveMember(fullyQualifiedPackageNameClassName.substring(0, lastIndexOfDot), newNestedClassName, member, label);
                }
                return Optional.empty();
            }
            return Optional.of(new FullyQualifiedJavadocReference(javaPackage.getName(), label, this.isExternal(javaPackage)));
        }
        if (!nestedClassName.isEmpty() && (javaClass = javaClass.getNestedClassByName(nestedClassName)) == null) {
            return Optional.empty();
        }
        return this.resolveMember(javaClass, member, label);
    }

    private boolean isExternal(JavaClass javaClass) {
        return this.isExternal(javaClass.getPackage());
    }

    private boolean isExternal(JavaPackage javaPackage) {
        return !javaPackage.getJavaClassLibrary().equals((Object)this.mojoClass.getJavaClassLibrary());
    }

    private Optional<FullyQualifiedJavadocReference> resolveMember(JavaClass javaClass, Optional<String> member, Optional<String> label) {
        Optional<Object> memberType;
        Optional<String> resolvedMember = member;
        if (member.isPresent()) {
            if (javaClass.getFieldByName(member.get()) == null) {
                List<JavaType> parameterTypes = this.getParameterTypes(member.get());
                String methodName = JavaClassConverterContext.getMethodName(member.get());
                if (javaClass.getMethodBySignature(methodName, parameterTypes) == null) {
                    if (!methodName.equals(javaClass.getSimpleName()) || javaClass.getConstructor(parameterTypes) == null) {
                        return Optional.empty();
                    }
                    memberType = Optional.of(FullyQualifiedJavadocReference.MemberType.CONSTRUCTOR);
                } else {
                    memberType = Optional.of(FullyQualifiedJavadocReference.MemberType.METHOD);
                }
                StringBuilder memberBuilder = new StringBuilder(methodName);
                memberBuilder.append("(");
                memberBuilder.append(parameterTypes.stream().map(JavaType::getFullyQualifiedName).collect(Collectors.joining(",")));
                memberBuilder.append(")");
                resolvedMember = Optional.of(memberBuilder.toString());
            } else {
                memberType = Optional.of(FullyQualifiedJavadocReference.MemberType.FIELD);
            }
        } else {
            memberType = Optional.empty();
        }
        String className = javaClass.getCanonicalName().substring(javaClass.getPackageName().length() + 1);
        return Optional.of(new FullyQualifiedJavadocReference(javaClass.getPackageName(), Optional.of(className), resolvedMember, memberType, label, this.isExternal(javaClass)));
    }

    private static boolean isClassFound(JavaClass javaClass) {
        return !(javaClass.getJavaClassLibrary() instanceof ClassNameLibrary);
    }

    private List<JavaType> getParameterTypes(String member) {
        ArrayList<JavaType> parameterTypes = new ArrayList<JavaType>();
        TypeResolver typeResolver = TypeResolver.byClassName((String)this.declaringClass.getPackageName(), (ClassLibrary)this.declaringClass.getJavaClassLibrary(), (Collection)this.declaringClass.getSource().getImports());
        int indexOfOpeningParenthesis = member.indexOf(40);
        int indexOfClosingParenthesis = member.indexOf(41);
        if (indexOfOpeningParenthesis < 0 || indexOfClosingParenthesis <= 0 || indexOfClosingParenthesis <= indexOfOpeningParenthesis) {
            if (indexOfOpeningParenthesis == -1 && indexOfClosingParenthesis >= 0 || indexOfOpeningParenthesis >= 0 && indexOfOpeningParenthesis == -1) {
                throw new IllegalArgumentException("Found opening without closing parentheses or vice versa in " + member);
            }
            return Collections.emptyList();
        }
        String signatureArguments = member.substring(indexOfOpeningParenthesis + 1, indexOfClosingParenthesis);
        for (String parameter : signatureArguments.split(",")) {
            String canonicalParameter = parameter.trim();
            int spaceIndex = canonicalParameter.indexOf(32);
            String typeName = spaceIndex > 0 ? canonicalParameter.substring(0, spaceIndex).trim() : canonicalParameter;
            if (typeName.isEmpty()) continue;
            String rawTypeName = JavaClassConverterContext.getRawTypeName(typeName);
            if (typeResolver.resolveType(rawTypeName) == null) {
                throw new IllegalArgumentException("Found unresolvable method argument type in " + member);
            }
            TypeDef typeDef = new TypeDef(JavaClassConverterContext.getRawTypeName(typeName));
            int dimensions = JavaClassConverterContext.getDimensions(typeName);
            DefaultJavaType javaType = TypeAssembler.createUnresolved((TypeDef)typeDef, (int)dimensions, (TypeResolver)typeResolver);
            parameterTypes.add((JavaType)javaType);
        }
        return parameterTypes;
    }

    private static int getDimensions(String type) {
        return (int)type.chars().filter(ch -> ch == 91).count();
    }

    private static String getRawTypeName(String typeName) {
        int indexOfOpeningBracket = typeName.indexOf(91);
        if (indexOfOpeningBracket >= 0) {
            return typeName.substring(0, indexOfOpeningBracket);
        }
        return typeName;
    }

    private static String getMethodName(String member) {
        int indexOfOpeningParentheses = member.indexOf(40);
        if (indexOfOpeningParentheses == -1) {
            return member;
        }
        return member.substring(0, indexOfOpeningParentheses);
    }

    @Override
    public <T> T setAttribute(String name, T value) {
        return (T)this.attributes.put(name, value);
    }

    @Override
    public <T> T getAttribute(String name, Class<T> clazz, T defaultValue) {
        return (T)this.attributes.getOrDefault(name, defaultValue);
    }
}

