/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.asserting;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.index.AssertingLeafReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.TestUtil;

public final class AssertingPointsFormat
extends PointsFormat {
    private final PointsFormat in;

    public AssertingPointsFormat() {
        this(TestUtil.getDefaultCodec().pointsFormat());
    }

    public AssertingPointsFormat(PointsFormat in) {
        this.in = in;
    }

    public PointsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new AssertingPointsWriter(state, this.in.fieldsWriter(state));
    }

    public PointsReader fieldsReader(SegmentReadState state) throws IOException {
        return new AssertingPointsReader(state.segmentInfo.maxDoc(), this.in.fieldsReader(state));
    }

    static class AssertingPointsWriter
    extends PointsWriter {
        private final PointsWriter in;

        AssertingPointsWriter(SegmentWriteState writeState, PointsWriter in) {
            this.in = in;
        }

        public void writeField(FieldInfo fieldInfo, PointsReader values) throws IOException {
            if (fieldInfo.getPointDataDimensionCount() == 0) {
                throw new IllegalArgumentException("writing field=\"" + fieldInfo.name + "\" but pointDataDimensionalCount is 0");
            }
            this.in.writeField(fieldInfo, values);
        }

        public void merge(MergeState mergeState) throws IOException {
            this.in.merge(mergeState);
        }

        public void finish() throws IOException {
            this.in.finish();
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }
    }

    static class AssertingPointsReader
    extends PointsReader {
        private final PointsReader in;
        private final int maxDoc;

        AssertingPointsReader(int maxDoc, PointsReader in) {
            this.in = in;
            this.maxDoc = maxDoc;
            assert (this.toString() != null);
            assert (this.ramBytesUsed() >= 0L);
            assert (this.getChildResources() != null);
        }

        public void close() throws IOException {
            this.in.close();
            this.in.close();
        }

        public PointValues getValues(String field) throws IOException {
            PointValues values = this.in.getValues(field);
            if (values == null) {
                return null;
            }
            return new AssertingLeafReader.AssertingPointValues(values, this.maxDoc);
        }

        public long ramBytesUsed() {
            long v = this.in.ramBytesUsed();
            assert (v >= 0L);
            return v;
        }

        public Collection<Accountable> getChildResources() {
            Collection res = this.in.getChildResources();
            TestUtil.checkReadOnly(res);
            return res;
        }

        public void checkIntegrity() throws IOException {
            this.in.checkIntegrity();
        }

        public PointsReader getMergeInstance() throws IOException {
            return new AssertingPointsReader(this.maxDoc, this.in.getMergeInstance());
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "(" + this.in.toString() + ")";
        }
    }
}

