/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.utils;

import org.apache.linkis.manager.common.entity.persistence.PersistenceResource;
import org.apache.linkis.manager.common.entity.resource.CPUResource;
import org.apache.linkis.manager.common.entity.resource.CommonNodeResource;
import org.apache.linkis.manager.common.entity.resource.DriverAndYarnResource;
import org.apache.linkis.manager.common.entity.resource.InstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadInstanceResource;
import org.apache.linkis.manager.common.entity.resource.LoadResource;
import org.apache.linkis.manager.common.entity.resource.NodeResource;
import org.apache.linkis.manager.common.entity.resource.Resource;
import org.apache.linkis.manager.common.entity.resource.ResourceSerializer$;
import org.apache.linkis.manager.common.entity.resource.ResourceType;
import org.apache.linkis.manager.common.entity.resource.SpecialResource;
import org.apache.linkis.manager.common.entity.resource.UserResource;
import org.apache.linkis.manager.common.entity.resource.YarnResource;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.Serializer;
import org.json4s.jackson.Serialization$;
import scala.Predef$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class ResourceUtils$ {
    public static final ResourceUtils$ MODULE$;
    private final Formats formats;

    static {
        new ResourceUtils$();
    }

    public Formats formats() {
        return this.formats;
    }

    public Resource deserializeResource(String plainResource) {
        return (Resource)Serialization$.MODULE$.read(plainResource, this.formats(), ManifestFactory$.MODULE$.classType(Resource.class));
    }

    public String serializeResource(Resource resource) {
        return Serialization$.MODULE$.write((Object)resource, this.formats());
    }

    /*
     * WARNING - void declaration
     */
    public PersistenceResource toPersistenceResource(NodeResource nodeResource) {
        void var2_2;
        PersistenceResource persistenceResource = new PersistenceResource();
        if (nodeResource.getMaxResource() != null) {
            persistenceResource.setMaxResource(this.serializeResource(nodeResource.getMaxResource()));
        }
        if (nodeResource.getMinResource() != null) {
            persistenceResource.setMinResource(this.serializeResource(nodeResource.getMinResource()));
        }
        if (nodeResource.getLockedResource() != null) {
            persistenceResource.setLockedResource(this.serializeResource(nodeResource.getLockedResource()));
        }
        if (nodeResource.getExpectedResource() != null) {
            persistenceResource.setExpectedResource(this.serializeResource(nodeResource.getExpectedResource()));
        }
        if (nodeResource.getLeftResource() != null) {
            persistenceResource.setLeftResource(this.serializeResource(nodeResource.getLeftResource()));
        }
        if (nodeResource.getUsedResource() != null) {
            persistenceResource.setUsedResource(this.serializeResource(nodeResource.getUsedResource()));
        }
        persistenceResource.setResourceType(nodeResource.getResourceType().toString());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public CommonNodeResource fromPersistenceResource(PersistenceResource persistenceResource) {
        void var2_2;
        if (persistenceResource == null) {
            return null;
        }
        CommonNodeResource nodeResource = new CommonNodeResource();
        if (BoxesRunTime.boxToInteger((int)persistenceResource.getId()) != null) {
            nodeResource.setId(Predef$.MODULE$.int2Integer(persistenceResource.getId()));
        }
        if (persistenceResource.getMaxResource() != null) {
            nodeResource.setMaxResource(this.deserializeResource(persistenceResource.getMaxResource()));
        }
        if (persistenceResource.getMinResource() != null) {
            nodeResource.setMinResource(this.deserializeResource(persistenceResource.getMinResource()));
        }
        if (persistenceResource.getLockedResource() != null) {
            nodeResource.setLockedResource(this.deserializeResource(persistenceResource.getLockedResource()));
        }
        if (persistenceResource.getExpectedResource() != null) {
            nodeResource.setExpectedResource(this.deserializeResource(persistenceResource.getExpectedResource()));
        }
        if (persistenceResource.getLeftResource() != null) {
            nodeResource.setLeftResource(this.deserializeResource(persistenceResource.getLeftResource()));
        }
        if (persistenceResource.getUsedResource() != null) {
            nodeResource.setUsedResource(this.deserializeResource(persistenceResource.getUsedResource()));
        }
        if (persistenceResource.getCreateTime() != null) {
            nodeResource.setCreateTime(persistenceResource.getCreateTime());
        }
        if (persistenceResource.getUpdateTime() != null) {
            nodeResource.setUpdateTime(persistenceResource.getUpdateTime());
        }
        nodeResource.setResourceType(ResourceType.valueOf(persistenceResource.getResourceType()));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public UserResource fromPersistenceResourceAndUser(PersistenceResource persistenceResource) {
        void var2_2;
        if (persistenceResource == null) {
            return null;
        }
        UserResource nodeResource = new UserResource();
        if (BoxesRunTime.boxToInteger((int)persistenceResource.getId()) != null) {
            nodeResource.setId(Predef$.MODULE$.int2Integer(persistenceResource.getId()));
        }
        if (persistenceResource.getMaxResource() != null) {
            nodeResource.setMaxResource(this.deserializeResource(persistenceResource.getMaxResource()));
        }
        if (persistenceResource.getMinResource() != null) {
            nodeResource.setMinResource(this.deserializeResource(persistenceResource.getMinResource()));
        }
        if (persistenceResource.getLockedResource() != null) {
            nodeResource.setLockedResource(this.deserializeResource(persistenceResource.getLockedResource()));
        }
        if (persistenceResource.getExpectedResource() != null) {
            nodeResource.setExpectedResource(this.deserializeResource(persistenceResource.getExpectedResource()));
        }
        if (persistenceResource.getLeftResource() != null) {
            nodeResource.setLeftResource(this.deserializeResource(persistenceResource.getLeftResource()));
        }
        if (persistenceResource.getUsedResource() != null) {
            nodeResource.setUsedResource(this.deserializeResource(persistenceResource.getUsedResource()));
        }
        if (persistenceResource.getCreateTime() != null) {
            nodeResource.setCreateTime(persistenceResource.getCreateTime());
        }
        if (persistenceResource.getUpdateTime() != null) {
            nodeResource.setUpdateTime(persistenceResource.getUpdateTime());
        }
        nodeResource.setResourceType(ResourceType.valueOf(persistenceResource.getResourceType()));
        return var2_2;
    }

    public ResourceType getResourceTypeByResource(Resource resource) {
        Resource resource2 = resource;
        ResourceType resourceType = resource2 instanceof CPUResource ? ResourceType.CPU : (resource2 instanceof LoadResource ? ResourceType.Load : (resource2 instanceof InstanceResource ? ResourceType.Instance : (resource2 instanceof LoadInstanceResource ? ResourceType.LoadInstance : (resource2 instanceof YarnResource ? ResourceType.Yarn : (resource2 instanceof DriverAndYarnResource ? ResourceType.DriverAndYarn : (resource2 instanceof SpecialResource ? ResourceType.Special : ResourceType.LoadInstance))))));
        return resourceType;
    }

    public NodeResource convertTo(NodeResource nodeResource, ResourceType resourceType) {
        if (nodeResource.getResourceType().equals((Object)resourceType)) {
            return nodeResource;
        }
        if (resourceType.equals((Object)ResourceType.LoadInstance) && nodeResource.getResourceType().equals((Object)ResourceType.DriverAndYarn)) {
            nodeResource.setResourceType(resourceType);
            if (nodeResource.getMaxResource() != null) {
                nodeResource.setMaxResource(((DriverAndYarnResource)nodeResource.getMaxResource()).loadInstanceResource());
            }
            if (nodeResource.getMinResource() != null) {
                nodeResource.setMinResource(((DriverAndYarnResource)nodeResource.getMinResource()).loadInstanceResource());
            }
            if (nodeResource.getUsedResource() != null) {
                nodeResource.setUsedResource(((DriverAndYarnResource)nodeResource.getUsedResource()).loadInstanceResource());
            }
            if (nodeResource.getLockedResource() != null) {
                nodeResource.setLockedResource(((DriverAndYarnResource)nodeResource.getLockedResource()).loadInstanceResource());
            }
            if (nodeResource.getExpectedResource() != null) {
                nodeResource.setExpectedResource(((DriverAndYarnResource)nodeResource.getExpectedResource()).loadInstanceResource());
            }
            if (nodeResource.getLeftResource() != null && nodeResource.getLeftResource() instanceof DriverAndYarnResource) {
                nodeResource.setLeftResource(((DriverAndYarnResource)nodeResource.getLeftResource()).loadInstanceResource());
            }
            return nodeResource;
        }
        return nodeResource;
    }

    public float getLoadInstanceResourceRate(Resource leftResource, Resource maxResource) {
        float f;
        if (leftResource == null) {
            return 0.0f;
        }
        if (maxResource == null) {
            return 1.0f;
        }
        Resource resource = leftResource;
        if (resource instanceof LoadInstanceResource) {
            float f2;
            LoadInstanceResource loadInstanceResource = (LoadInstanceResource)resource;
            Resource resource2 = maxResource;
            if (resource2 instanceof LoadInstanceResource) {
                LoadInstanceResource loadInstanceResource2 = (LoadInstanceResource)resource2;
                float cpuRate = loadInstanceResource2.cores() > 0 ? (float)loadInstanceResource.cores() * 1.0f / (float)loadInstanceResource2.cores() : 1.0f;
                float memoryRate = loadInstanceResource2.memory() > 0L ? (float)((double)loadInstanceResource.memory() * 1.0) / (float)loadInstanceResource2.memory() : 1.0f;
                float instanceRate = loadInstanceResource2.instances() > 0 ? (float)loadInstanceResource.instances() * 1.0f / (float)loadInstanceResource2.instances() : 1.0f;
                f2 = Math.min(Math.min(cpuRate, memoryRate), instanceRate);
            } else {
                f2 = 1.0f;
            }
            f = f2;
        } else {
            f = 1.0f;
        }
        return f;
    }

    private ResourceUtils$() {
        MODULE$ = this;
        this.formats = DefaultFormats$.MODULE$.$plus((Serializer)ResourceSerializer$.MODULE$);
    }
}

