/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.common.entity.resource;

import org.apache.linkis.common.utils.ByteTimeUtils;
import org.apache.linkis.manager.common.entity.resource.Resource;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001#\tqQ*Z7pef\u0014Vm]8ve\u000e,'BA\u0002\u0005\u0003!\u0011Xm]8ve\u000e,'BA\u0003\u0007\u0003\u0019)g\u000e^5us*\u0011q\u0001C\u0001\u0007G>lWn\u001c8\u000b\u0005%Q\u0011aB7b]\u0006<WM\u001d\u0006\u0003\u00171\ta\u0001\\5oW&\u001c(BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0005%\u0011QC\u0001\u0002\t%\u0016\u001cx.\u001e:dK\"Aq\u0003\u0001BC\u0002\u0013\u0005\u0001$\u0001\u0004nK6|'/_\u000b\u00023A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t!Aj\u001c8h\u0011!\u0001\u0003A!A!\u0002\u0013I\u0012aB7f[>\u0014\u0018\u0010\t\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0011*\u0003CA\n\u0001\u0011\u00159\u0012\u00051\u0001\u001a\u0011\u00159\u0003\u0001b\u0003)\u0003A!x.T3n_JL(+Z:pkJ\u001cW\r\u0006\u0002%S!)!F\na\u0001%\u0005\t!\u000fC\u0003-\u0001\u0011\u0005S&A\u0002bI\u0012$\"A\u0005\u0018\t\u000b)Z\u0003\u0019\u0001\n\t\u000bA\u0002A\u0011I\u0019\u0002\u000b5Lg.^:\u0015\u0005I\u0011\u0004\"\u0002\u00160\u0001\u0004\u0011\u0002\"\u0002\u001b\u0001\t\u0003*\u0014AC7vYRL\u0007\u000f\\5fIR\u0011!C\u000e\u0005\u0006UM\u0002\rA\u0005\u0005\u0006i\u0001!\t\u0005\u000f\u000b\u0003%eBQAO\u001cA\u0002m\nAA]1uKB\u0011!\u0004P\u0005\u0003{m\u0011QA\u00127pCRDQa\u0010\u0001\u0005B\u0001\u000ba\u0001Z5wS\u0012,GC\u0001\nB\u0011\u0015Qc\b1\u0001\u0013\u0011\u0015y\u0004\u0001\"\u0011D)\t\u0011B\tC\u0003;\u0005\u0002\u0007Q\t\u0005\u0002\u001b\r&\u0011qi\u0007\u0002\u0004\u0013:$\b\"B%\u0001\t\u0003R\u0015\u0001C7pe\u0016$\u0006.\u00198\u0015\u0005-s\u0005C\u0001\u000eM\u0013\ti5DA\u0004C_>dW-\u00198\t\u000b)B\u0005\u0019\u0001\n\t\u000bA\u0003A\u0011I)\u0002\u000f9|G\u000fT3tgR\u00111J\u0015\u0005\u0006U=\u0003\rA\u0005\u0005\u0006)\u0002!\t%V\u0001\tG\u0006\u001cX-T8sKR\u00111J\u0016\u0005\u0006UM\u0003\rA\u0005\u0005\u00061\u0002!\t%W\u0001\tKF,\u0018\r\\:U_R\u00111J\u0017\u0005\u0006U]\u0003\rA\u0005\u0005\u00069\u0002!\t%X\u0001\u0007i>T5o\u001c8\u0016\u0003y\u0003\"a\u00182\u000f\u0005i\u0001\u0017BA1\u001c\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\\\u0002\"\u00024\u0001\t\u0003:\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\u0003")
public class MemoryResource
extends Resource {
    private final long memory;

    public long memory() {
        return this.memory;
    }

    private MemoryResource toMemoryResource(Resource r) {
        MemoryResource memoryResource;
        Resource resource = r;
        MemoryResource memoryResource2 = resource instanceof MemoryResource ? (memoryResource = (MemoryResource)resource) : new MemoryResource(Long.MAX_VALUE);
        return memoryResource2;
    }

    @Override
    public Resource add(Resource r) {
        return new MemoryResource(this.memory() + this.toMemoryResource(r).memory());
    }

    @Override
    public Resource minus(Resource r) {
        return new MemoryResource(this.memory() - this.toMemoryResource(r).memory());
    }

    @Override
    public Resource multiplied(Resource r) {
        return new MemoryResource(this.memory() * this.toMemoryResource(r).memory());
    }

    @Override
    public Resource multiplied(float rate) {
        return new MemoryResource((long)((double)this.memory() * (double)rate));
    }

    @Override
    public Resource divide(Resource r) {
        return new MemoryResource(this.memory() / this.toMemoryResource(r).memory());
    }

    @Override
    public Resource divide(int rate) {
        return new MemoryResource(this.memory() / (long)rate);
    }

    @Override
    public boolean moreThan(Resource r) {
        return this.memory() > this.toMemoryResource(r).memory();
    }

    @Override
    public boolean notLess(Resource r) {
        return this.memory() >= this.toMemoryResource(r).memory();
    }

    @Override
    public boolean caseMore(Resource r) {
        return this.moreThan(r);
    }

    @Override
    public boolean equalsTo(Resource r) {
        return this.memory() == this.toMemoryResource(r).memory();
    }

    @Override
    public String toJson() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" \"memory\":\"", "\" "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ByteTimeUtils.bytesToString((long)this.memory())}));
    }

    public String toString() {
        return this.toJson();
    }

    public MemoryResource(long memory) {
        this.memory = memory;
    }
}

